/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.standard.commands;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import javax.validation.metadata.ConstraintDescriptor;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.shell.Availability;
import org.springframework.shell.CommandRegistry;
import org.springframework.shell.MethodTarget;
import org.springframework.shell.ParameterDescription;
import org.springframework.shell.ParameterResolver;
import org.springframework.shell.Utils;
import org.springframework.shell.standard.CommandValueProvider;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
public class Help {
    private final List<ParameterResolver> parameterResolvers;
    private CommandRegistry commandRegistry;
    private MessageInterpolator messageInterpolator = Validation.buildDefaultValidatorFactory().getMessageInterpolator();

    @Autowired
    public Help(List<ParameterResolver> parameterResolvers) {
        this.parameterResolvers = parameterResolvers;
    }

    @Autowired
    public void setCommandRegistry(CommandRegistry commandRegistry) {
        this.commandRegistry = commandRegistry;
    }

    @Autowired(required=false)
    public void setValidatorFactory(ValidatorFactory validatorFactory) {
        this.messageInterpolator = validatorFactory.getMessageInterpolator();
    }

    @ShellMethod(value="Display help about available commands.", prefix="-")
    public CharSequence help(@ShellOption(defaultValue="__NULL__", valueProvider=CommandValueProvider.class, value={"-C", "--command"}, help="The command to obtain help for.") String command) throws IOException {
        if (command == null) {
            return this.listCommands();
        }
        return this.documentCommand(command);
    }

    private CharSequence documentCommand(String command) {
        MethodTarget methodTarget = (MethodTarget)this.commandRegistry.listCommands().get(command);
        if (methodTarget == null) {
            throw new IllegalArgumentException("Unknown command '" + command + "'");
        }
        AttributedStringBuilder result = new AttributedStringBuilder().append((CharSequence)"\n\n");
        List<ParameterDescription> parameterDescriptions = this.getParameterDescriptions(methodTarget);
        this.documentCommandName(result, command, methodTarget.getHelp());
        this.documentSynopsys(result, command, parameterDescriptions);
        this.documentOptions(result, parameterDescriptions);
        this.documentAliases(result, command, methodTarget);
        this.documentAvailability(result, methodTarget);
        result.append((CharSequence)"\n");
        return result;
    }

    private void documentCommandName(AttributedStringBuilder result, String command, String help) {
        result.append((CharSequence)"NAME", AttributedStyle.BOLD).append((CharSequence)"\n\t");
        result.append((CharSequence)command).append((CharSequence)" - ").append((CharSequence)help).append((CharSequence)"\n\n");
    }

    private void documentSynopsys(AttributedStringBuilder result, String command, List<ParameterDescription> parameterDescriptions) {
        result.append((CharSequence)"SYNOPSYS", AttributedStyle.BOLD).append((CharSequence)"\n\t");
        result.append((CharSequence)command, AttributedStyle.BOLD);
        result.append((CharSequence)" ");
        for (ParameterDescription description : parameterDescriptions) {
            List keys;
            if (description.defaultValue().isPresent() && description.formal().length() > 0) {
                result.append((CharSequence)"[");
            }
            if (!(keys = description.keys()).isEmpty()) {
                if (!description.mandatoryKey()) {
                    result.append((CharSequence)"[");
                }
                result.append((CharSequence)this.first(keys), AttributedStyle.BOLD);
                if (!description.mandatoryKey()) {
                    result.append((CharSequence)"]");
                }
                if (!description.formal().isEmpty()) {
                    result.append((CharSequence)" ");
                }
            }
            if (description.defaultValueWhenFlag().isPresent()) {
                result.append((CharSequence)"[");
            }
            this.appendUnderlinedFormal(result, description);
            if (description.defaultValueWhenFlag().isPresent()) {
                result.append((CharSequence)"]");
            }
            if (description.defaultValue().isPresent() && description.formal().length() > 0) {
                result.append((CharSequence)"]");
            }
            result.append((CharSequence)"  ");
        }
        result.append((CharSequence)"\n\n");
    }

    private void documentOptions(AttributedStringBuilder result, List<ParameterDescription> parameterDescriptions) {
        if (!parameterDescriptions.isEmpty()) {
            result.append((CharSequence)"OPTIONS", AttributedStyle.BOLD).append((CharSequence)"\n");
        }
        for (ParameterDescription description : parameterDescriptions) {
            result.append((CharSequence)"\t").append((CharSequence)description.keys().stream().collect(Collectors.joining(" or ")), AttributedStyle.BOLD);
            if (description.formal().length() > 0) {
                if (!description.keys().isEmpty()) {
                    result.append((CharSequence)"  ");
                }
                description.defaultValueWhenFlag().ifPresent(f -> result.append('['));
                this.appendUnderlinedFormal(result, description);
                description.defaultValueWhenFlag().ifPresent(f -> result.append(']'));
                result.append((CharSequence)"\n\t");
            } else if (description.keys().size() > 1) {
                result.append((CharSequence)"\n\t");
            }
            result.append((CharSequence)"\t");
            result.append((CharSequence)description.help()).append('\n');
            if (description.defaultValue().isPresent()) {
                result.append((CharSequence)"\t\t[Optional, default = ", AttributedStyle.BOLD).append((CharSequence)description.defaultValue().get(), AttributedStyle.BOLD.italic());
                description.defaultValueWhenFlag().ifPresent(s -> result.append((CharSequence)", or ", AttributedStyle.BOLD).append((CharSequence)s, AttributedStyle.BOLD.italic()).append((CharSequence)" if used as a flag", AttributedStyle.BOLD));
                result.append((CharSequence)"]", AttributedStyle.BOLD);
            } else if (description.defaultValueWhenFlag().isPresent()) {
                result.append((CharSequence)"\t\t[Mandatory, default = ", AttributedStyle.BOLD).append((CharSequence)description.defaultValueWhenFlag().get(), AttributedStyle.BOLD.italic()).append((CharSequence)" when used as a flag]", AttributedStyle.BOLD);
            } else {
                result.append((CharSequence)"\t\t[Mandatory]", AttributedStyle.BOLD);
            }
            result.append('\n');
            if (description.elementDescriptor() != null) {
                for (ConstraintDescriptor constraintDescriptor : description.elementDescriptor().getConstraintDescriptors()) {
                    String friendlyConstraint = this.messageInterpolator.interpolate(constraintDescriptor.getMessageTemplate(), (MessageInterpolator.Context)new DummyContext(constraintDescriptor));
                    result.append((CharSequence)("\t\t[" + friendlyConstraint + "]\n"), AttributedStyle.BOLD);
                }
            }
            result.append('\n');
        }
    }

    private void documentAliases(AttributedStringBuilder result, String command, MethodTarget methodTarget) {
        Set aliases = this.commandRegistry.listCommands().entrySet().stream().filter(e -> ((MethodTarget)e.getValue()).equals((Object)methodTarget)).map(Map.Entry::getKey).filter(c -> !command.equals(c)).collect(Collectors.toCollection(TreeSet::new));
        if (!aliases.isEmpty()) {
            result.append((CharSequence)"ALSO KNOWN AS", AttributedStyle.BOLD).append((CharSequence)"\n");
            for (String alias : aliases) {
                result.append('\t').append((CharSequence)alias).append('\n');
            }
        }
    }

    private void documentAvailability(AttributedStringBuilder result, MethodTarget methodTarget) {
        Availability availability = methodTarget.getAvailability();
        if (!availability.isAvailable()) {
            result.append((CharSequence)"CURRENTLY UNAVAILABLE", AttributedStyle.BOLD).append((CharSequence)"\n");
            result.append('\t').append((CharSequence)"This command is currently not available because ").append((CharSequence)availability.getReason()).append((CharSequence)".\n");
        }
    }

    private String first(List<String> keys) {
        return keys.iterator().next();
    }

    private CharSequence listCommands() {
        Map commandsByName = this.commandRegistry.listCommands();
        SortedMap commandsByGroupAndName = commandsByName.entrySet().stream().collect(Collectors.groupingBy(e -> ((MethodTarget)e.getValue()).getGroup(), TreeMap::new, Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        AttributedStringBuilder result = new AttributedStringBuilder();
        result.append((CharSequence)"AVAILABLE COMMANDS\n\n", AttributedStyle.BOLD);
        commandsByGroupAndName.forEach((group, commandsInGroup) -> {
            result.append((CharSequence)("".equals(group) ? "Default" : group), AttributedStyle.BOLD).append('\n');
            Map<MethodTarget, SortedSet> commandNamesByMethod = commandsInGroup.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toCollection(TreeSet::new))));
            commandNamesByMethod.entrySet().stream().sorted(this.sortByFirstCommandName()).forEach(e -> result.append((CharSequence)(this.isAvailable((MethodTarget)e.getKey()) ? "        " : "      * ")).append((CharSequence)String.join((CharSequence)", ", (Iterable)e.getValue()), AttributedStyle.BOLD).append((CharSequence)": ").append((CharSequence)((MethodTarget)e.getKey()).getHelp()).append('\n'));
            result.append('\n');
        });
        if (commandsByName.values().stream().distinct().anyMatch(m -> !this.isAvailable((MethodTarget)m))) {
            result.append((CharSequence)"Commands marked with (*) are currently unavailable.\nType `help <command>` to learn more.\n\n");
        }
        return result;
    }

    private Comparator<Map.Entry<MethodTarget, SortedSet<String>>> sortByFirstCommandName() {
        return Comparator.comparing(e -> (String)((SortedSet)e.getValue()).first());
    }

    private boolean isAvailable(MethodTarget methodTarget) {
        return methodTarget.getAvailability().isAvailable();
    }

    private void appendUnderlinedFormal(AttributedStringBuilder result, ParameterDescription description) {
        for (char c : description.formal().toCharArray()) {
            if (c != ' ') {
                result.append((CharSequence)("" + c), AttributedStyle.DEFAULT.underline());
                continue;
            }
            result.append(c);
        }
    }

    private List<ParameterDescription> getParameterDescriptions(MethodTarget methodTarget) {
        return Utils.createMethodParameters((Executable)methodTarget.getMethod()).flatMap(mp -> this.parameterResolvers.stream().filter(pr -> pr.supports(mp)).limit(1L).flatMap(pr -> pr.describe(mp))).collect(Collectors.toList());
    }

    private static class DummyContext
    implements MessageInterpolator.Context {
        private final ConstraintDescriptor<?> descriptor;

        private DummyContext(ConstraintDescriptor<?> descriptor) {
            this.descriptor = descriptor;
        }

        public ConstraintDescriptor<?> getConstraintDescriptor() {
            return this.descriptor;
        }

        public Object getValidatedValue() {
            return null;
        }

        public <T> T unwrap(Class<T> type) {
            return null;
        }
    }

    public static interface Command {
    }
}

