/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.domain;

import org.springframework.security.acls.model.Sid;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;

public class PrincipalSid
implements Sid {
    private final String principal;

    public PrincipalSid(String principal) {
        Assert.hasText((String)principal, (String)"Principal required");
        this.principal = principal;
    }

    public PrincipalSid(Authentication authentication) {
        Assert.notNull((Object)authentication, (String)"Authentication required");
        Assert.notNull((Object)authentication.getPrincipal(), (String)"Principal required");
        this.principal = authentication.getPrincipal() instanceof UserDetails ? ((UserDetails)authentication.getPrincipal()).getUsername() : authentication.getPrincipal().toString();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof PrincipalSid)) {
            return false;
        }
        return ((PrincipalSid)object).getPrincipal().equals(this.getPrincipal());
    }

    public int hashCode() {
        return this.getPrincipal().hashCode();
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String toString() {
        return "PrincipalSid[" + this.principal + "]";
    }
}

