/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.pdx;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.RegionService;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.PdxInstanceFactory;
import org.springframework.geode.cache.SimpleCacheResolver;

public class PdxInstanceBuilder {
    private final RegionService regionService;
    private PdxInstanceFactory pdxFactory;

    public static PdxInstanceBuilder create() {
        return PdxInstanceBuilder.create(SimpleCacheResolver.getInstance().require());
    }

    public static PdxInstanceBuilder create(RegionService regionService) {
        return new PdxInstanceBuilder(regionService);
    }

    private static void assertNotNull(Object target, String message, Object ... arguments) {
        if (target == null) {
            throw new IllegalArgumentException(String.format(message, arguments));
        }
    }

    private static <T> List<T> nullSafeList(List<T> list) {
        return list != null ? list : Collections.emptyList();
    }

    protected PdxInstanceBuilder(RegionService regionService) {
        PdxInstanceBuilder.assertNotNull(regionService, "RegionService must not be null", new Object[0]);
        this.regionService = regionService;
    }

    protected RegionService getRegionService() {
        return this.regionService;
    }

    public PdxInstanceFactory copy(PdxInstance pdxInstance) {
        PdxInstanceBuilder.assertNotNull(pdxInstance, "PdxInstance must not be null", new Object[0]);
        PdxInstanceFactory factory = this.getRegionService().createPdxInstanceFactory(pdxInstance.getClassName());
        PdxInstanceBuilder.nullSafeList(pdxInstance.getFieldNames()).forEach(fieldName -> {
            factory.writeObject(fieldName, pdxInstance.getField(fieldName));
            if (pdxInstance.isIdentityField(fieldName)) {
                factory.markIdentityField(fieldName);
            }
        });
        return factory;
    }

    public Factory from(Object source) {
        PdxInstanceBuilder.assertNotNull(source, "Source object to serialize to PDX must not be null", new Object[0]);
        RegionService regionService = this.getRegionService();
        Optional.of(regionService).filter(GemFireCache.class::isInstance).map(GemFireCache.class::cast).map(GemFireCache::getPdxReadSerialized).filter(Boolean.TRUE::equals).orElseThrow(() -> new IllegalStateException("PDX read-serialized must be set to true"));
        PdxInstanceFactory factory = regionService.createPdxInstanceFactory(source.getClass().getName());
        factory.writeObject("source", source);
        AtomicReference<Object> resolvedSource = new AtomicReference<Object>(null);
        return () -> Optional.of(factory).map(PdxInstanceFactory::create).map(pdxInstance -> resolvedSource.updateAndGet(it -> pdxInstance.getField("source"))).filter(PdxInstance.class::isInstance).map(PdxInstance.class::cast).orElseThrow(() -> {
            String message = String.format("Expected an instance of PDX but was an instance of type [%s]; Was PDX read-serialized set to true", this.nullSafeClassName(resolvedSource.get()));
            return new IllegalArgumentException(message);
        });
    }

    private String nullSafeClassName(Object target) {
        return target != null ? target.getClass().getName() : null;
    }

    @FunctionalInterface
    public static interface Factory {
        public PdxInstance create();
    }
}

