/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.distributed.event;

import java.util.EventListener;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.springframework.geode.distributed.event.support.MemberDepartedEvent;
import org.springframework.geode.distributed.event.support.MemberJoinedEvent;
import org.springframework.geode.distributed.event.support.MemberSuspectEvent;
import org.springframework.geode.distributed.event.support.QuorumLostEvent;

public abstract class MembershipListenerAdapter<T extends MembershipListenerAdapter<T>>
implements EventListener,
MembershipListener {
    public final void memberDeparted(DistributionManager manager, InternalDistributedMember member, boolean crashed) {
        MemberDepartedEvent event = ((MemberDepartedEvent)new MemberDepartedEvent(manager).withMember((DistributedMember)member)).crashed(crashed);
        this.handleMemberDeparted(event);
    }

    public void handleMemberDeparted(MemberDepartedEvent event) {
    }

    public final void memberJoined(DistributionManager manager, InternalDistributedMember member) {
        MemberJoinedEvent event = (MemberJoinedEvent)new MemberJoinedEvent(manager).withMember((DistributedMember)member);
        this.handleMemberJoined(event);
    }

    public void handleMemberJoined(MemberJoinedEvent event) {
    }

    public final void memberSuspect(DistributionManager manager, InternalDistributedMember member, InternalDistributedMember suspectMember, String reason) {
        MemberSuspectEvent event = ((MemberSuspectEvent)new MemberSuspectEvent(manager).withMember((DistributedMember)member)).withReason(reason).withSuspect((DistributedMember)suspectMember);
        this.handleMemberSuspect(event);
    }

    public void handleMemberSuspect(MemberSuspectEvent event) {
    }

    public final void quorumLost(DistributionManager manager, Set<InternalDistributedMember> failedMembers, List<InternalDistributedMember> remainingMembers) {
        QuorumLostEvent event = new QuorumLostEvent(manager).withFailedMembers(failedMembers).withRemainingMembers(remainingMembers);
        this.handleQuorumLost(event);
    }

    public void handleQuorumLost(QuorumLostEvent event) {
    }

    public T register(Cache peerCache) {
        Optional.ofNullable(peerCache).map(GemFireCache::getDistributedSystem).filter(InternalDistributedSystem.class::isInstance).map(InternalDistributedSystem.class::cast).map(InternalDistributedSystem::getDistributionManager).ifPresent(distributionManager -> distributionManager.addMembershipListener((MembershipListener)this));
        return (T)this;
    }
}

