/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportResource;
import org.springframework.core.Ordered;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.data.auditing.AuditableBeanWrapperFactory;
import org.springframework.data.auditing.MappingAuditableBeanWrapperFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.geo.GeoModule;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.querydsl.QuerydslUtils;
import org.springframework.data.querydsl.binding.QuerydslBindingsFactory;
import org.springframework.data.querydsl.binding.QuerydslPredicateBuilder;
import org.springframework.data.repository.support.DefaultRepositoryInvokerFactory;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.data.rest.core.StringToLdapNameConverter;
import org.springframework.data.rest.core.UriToEntityConverter;
import org.springframework.data.rest.core.config.MetadataConfiguration;
import org.springframework.data.rest.core.config.Projection;
import org.springframework.data.rest.core.config.ProjectionDefinitionConfiguration;
import org.springframework.data.rest.core.config.RepositoryCorsRegistry;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.event.AnnotatedEventHandlerInvoker;
import org.springframework.data.rest.core.event.ValidatingRepositoryEventListener;
import org.springframework.data.rest.core.mapping.RepositoryResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.projection.ProjectionDefinitions;
import org.springframework.data.rest.core.support.DefaultSelfLinkProvider;
import org.springframework.data.rest.core.support.EntityLookup;
import org.springframework.data.rest.core.support.RepositoryRelProvider;
import org.springframework.data.rest.core.support.SelfLinkProvider;
import org.springframework.data.rest.core.support.UnwrappingRepositoryInvokerFactory;
import org.springframework.data.rest.webmvc.BasePathAwareHandlerMapping;
import org.springframework.data.rest.webmvc.BaseUri;
import org.springframework.data.rest.webmvc.EmbeddedResourcesAssembler;
import org.springframework.data.rest.webmvc.HttpHeadersPreparer;
import org.springframework.data.rest.webmvc.ProfileResourceProcessor;
import org.springframework.data.rest.webmvc.RepositoryRestExceptionHandler;
import org.springframework.data.rest.webmvc.RepositoryRestHandlerAdapter;
import org.springframework.data.rest.webmvc.RepositoryRestHandlerMapping;
import org.springframework.data.rest.webmvc.RestMediaTypes;
import org.springframework.data.rest.webmvc.ServerHttpRequestMethodArgumentResolver;
import org.springframework.data.rest.webmvc.alps.AlpsJsonHttpMessageConverter;
import org.springframework.data.rest.webmvc.alps.RootResourceInformationToAlpsDescriptorConverter;
import org.springframework.data.rest.webmvc.config.ArgumentResolverPagingAndSortingTemplateVariables;
import org.springframework.data.rest.webmvc.config.CorsConfigurationAware;
import org.springframework.data.rest.webmvc.config.DelegatingHandlerMapping;
import org.springframework.data.rest.webmvc.config.PersistentEntityResourceAssemblerArgumentResolver;
import org.springframework.data.rest.webmvc.config.PersistentEntityResourceHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.config.ProjectionDefinitionRegistar;
import org.springframework.data.rest.webmvc.config.QuerydslAwareRootResourceInformationHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.config.RepositoryRestConfigurer;
import org.springframework.data.rest.webmvc.config.RepositoryRestConfigurerDelegate;
import org.springframework.data.rest.webmvc.config.ResourceMetadataHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.config.RestControllerImportSelector;
import org.springframework.data.rest.webmvc.config.RootResourceInformationHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.config.StaticResourceProvider;
import org.springframework.data.rest.webmvc.config.WebMvcRepositoryRestConfiguration;
import org.springframework.data.rest.webmvc.convert.UriListHttpMessageConverter;
import org.springframework.data.rest.webmvc.json.DomainObjectReader;
import org.springframework.data.rest.webmvc.json.EnumTranslator;
import org.springframework.data.rest.webmvc.json.Jackson2DatatypeHelper;
import org.springframework.data.rest.webmvc.json.JacksonMappingAwareSortTranslator;
import org.springframework.data.rest.webmvc.json.JacksonSerializers;
import org.springframework.data.rest.webmvc.json.MappingAwareDefaultedPageableArgumentResolver;
import org.springframework.data.rest.webmvc.json.MappingAwarePageableArgumentResolver;
import org.springframework.data.rest.webmvc.json.MappingAwareSortArgumentResolver;
import org.springframework.data.rest.webmvc.json.PersistentEntityJackson2Module;
import org.springframework.data.rest.webmvc.json.PersistentEntityToJsonSchemaConverter;
import org.springframework.data.rest.webmvc.mapping.Associations;
import org.springframework.data.rest.webmvc.mapping.LinkCollector;
import org.springframework.data.rest.webmvc.spi.BackendIdConverter;
import org.springframework.data.rest.webmvc.support.BackendIdHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.support.DefaultExcerptProjector;
import org.springframework.data.rest.webmvc.support.DomainClassResolver;
import org.springframework.data.rest.webmvc.support.ETagArgumentResolver;
import org.springframework.data.rest.webmvc.support.ExcerptProjector;
import org.springframework.data.rest.webmvc.support.HttpMethodHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.support.JpaHelper;
import org.springframework.data.rest.webmvc.support.PagingAndSortingTemplateVariables;
import org.springframework.data.rest.webmvc.support.RepositoryEntityLinks;
import org.springframework.data.util.AnnotatedTypeScanner;
import org.springframework.data.util.Lazy;
import org.springframework.data.web.HateoasPageableHandlerMethodArgumentResolver;
import org.springframework.data.web.HateoasSortHandlerMethodArgumentResolver;
import org.springframework.data.web.PageableArgumentResolver;
import org.springframework.data.web.PageableHandlerMethodArgumentResolver;
import org.springframework.data.web.SortArgumentResolver;
import org.springframework.data.web.config.EnableSpringDataWebSupport;
import org.springframework.data.web.config.HateoasAwareSpringDataWebConfiguration;
import org.springframework.data.web.config.SpringDataJacksonConfiguration;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.hateoas.mediatype.MessageResolver;
import org.springframework.hateoas.mediatype.hal.CurieProvider;
import org.springframework.hateoas.mediatype.hal.DefaultCurieProvider;
import org.springframework.hateoas.mediatype.hal.HalConfiguration;
import org.springframework.hateoas.mediatype.hal.Jackson2HalModule;
import org.springframework.hateoas.server.EntityLinks;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.hateoas.server.core.EvoInflectorLinkRelationProvider;
import org.springframework.hateoas.server.mvc.RepresentationModelProcessorInvoker;
import org.springframework.hateoas.server.mvc.TypeConstrainedMappingJackson2HttpMessageConverter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;
import org.springframework.web.util.pattern.PathPatternParser;

@Configuration(proxyBeanMethods=false)
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
@ImportResource(value={"classpath*:META-INF/spring-data-rest/**/*.xml"})
@Import(value={RestControllerImportSelector.class, SpringDataJacksonConfiguration.class, EnableSpringDataWebSupport.QuerydslActivator.class})
public class RepositoryRestMvcConfiguration
extends HateoasAwareSpringDataWebConfiguration
implements BeanClassLoaderAware {
    private static final boolean IS_JPA_AVAILABLE = ClassUtils.isPresent((String)"javax.persistence.EntityManager", (ClassLoader)RepositoryRestMvcConfiguration.class.getClassLoader());
    @Autowired
    ApplicationContext applicationContext;
    @Autowired(required=false)
    List<BackendIdConverter> idConverters = Collections.emptyList();
    @Autowired(required=false)
    List<EntityLookup<?>> lookups = Collections.emptyList();
    @Autowired
    List<HttpMessageConverter<?>> defaultMessageConverters;
    ObjectProvider<LinkRelationProvider> relProvider;
    ObjectProvider<CurieProvider> curieProvider;
    ObjectProvider<HalConfiguration> halConfiguration;
    ObjectProvider<ObjectMapper> objectMapper;
    ObjectProvider<RepresentationModelProcessorInvoker> invoker;
    ObjectProvider<MessageResolver> resolver;
    ObjectProvider<GeoModule> geoModule;
    ConversionService defaultConversionService;
    private final Lazy<ObjectMapper> mapper;
    private final ObjectProvider<PathPatternParser> parser;
    private ClassLoader beanClassLoader;
    private Lazy<RepositoryRestConfigurerDelegate> configurerDelegate;
    private Lazy<SelfLinkProvider> selfLinkProvider;
    private Lazy<PersistentEntityResourceHandlerMethodArgumentResolver> persistentEntityArgumentResolver;
    private Lazy<RootResourceInformationHandlerMethodArgumentResolver> repoRequestArgumentResolver;
    private Lazy<BaseUri> baseUri;
    private Lazy<RepositoryResourceMappings> resourceMappings;
    private Lazy<Repositories> repositories;
    private Lazy<ResourceMetadataHandlerMethodArgumentResolver> resourceMetadataHandlerMethodArgumentResolver;
    private Lazy<ExcerptProjector> excerptProjector;
    private Lazy<PersistentEntities> persistentEntities;
    private Lazy<BackendIdHandlerMethodArgumentResolver> backendIdHandlerMethodArgumentResolver;
    private Lazy<Associations> associationLinks;
    private Lazy<EnumTranslator> enumTranslator;
    private Lazy<ServerHttpRequestMethodArgumentResolver> serverHttpRequestMethodArgumentResolver;
    private Lazy<ETagArgumentResolver> eTagArgumentResolver;
    private Lazy<RepositoryInvokerFactory> repositoryInvokerFactory;
    private Lazy<RepositoryRestConfiguration> repositoryRestConfiguration;
    private Lazy<HateoasPageableHandlerMethodArgumentResolver> pageableResolver;
    private Lazy<HateoasSortHandlerMethodArgumentResolver> sortResolver;

    public RepositoryRestMvcConfiguration(ApplicationContext context, @Qualifier(value="mvcConversionService") ObjectFactory<ConversionService> conversionService, ObjectProvider<LinkRelationProvider> relProvider, ObjectProvider<CurieProvider> curieProvider, ObjectProvider<HalConfiguration> halConfiguration, ObjectProvider<ObjectMapper> objectMapper, ObjectProvider<RepresentationModelProcessorInvoker> invoker, ObjectProvider<MessageResolver> resolver, ObjectProvider<GeoModule> geoModule, ObjectProvider<PathPatternParser> parser) {
        super(context, conversionService);
        this.relProvider = relProvider;
        this.curieProvider = curieProvider;
        this.halConfiguration = halConfiguration;
        this.objectMapper = objectMapper;
        this.invoker = invoker;
        this.resolver = resolver;
        this.geoModule = geoModule;
        this.parser = parser;
        this.mapper = Lazy.of(() -> {
            Jdk8Module jdk8Module = new Jdk8Module();
            jdk8Module.configureAbsentsAsNulls(true);
            ObjectMapper mapper = this.basicObjectMapper();
            LinkCollector linkCollector = (LinkCollector)context.getBean(LinkCollector.class);
            mapper.registerModule(this.persistentEntityJackson2Module(linkCollector));
            mapper.registerModule((Module)jdk8Module);
            return mapper;
        });
        this.selfLinkProvider = Lazy.of(() -> (SelfLinkProvider)context.getBean(SelfLinkProvider.class));
        this.persistentEntityArgumentResolver = Lazy.of(() -> (PersistentEntityResourceHandlerMethodArgumentResolver)context.getBean(PersistentEntityResourceHandlerMethodArgumentResolver.class));
        this.repoRequestArgumentResolver = Lazy.of(() -> (RootResourceInformationHandlerMethodArgumentResolver)context.getBean(RootResourceInformationHandlerMethodArgumentResolver.class));
        this.baseUri = Lazy.of(() -> (BaseUri)context.getBean(BaseUri.class));
        this.resourceMappings = Lazy.of(() -> (RepositoryResourceMappings)context.getBean(RepositoryResourceMappings.class));
        this.repositories = Lazy.of(() -> (Repositories)context.getBean(Repositories.class));
        this.resourceMetadataHandlerMethodArgumentResolver = Lazy.of(() -> (ResourceMetadataHandlerMethodArgumentResolver)context.getBean(ResourceMetadataHandlerMethodArgumentResolver.class));
        this.excerptProjector = Lazy.of(() -> (ExcerptProjector)context.getBean(ExcerptProjector.class));
        this.persistentEntities = Lazy.of(() -> (PersistentEntities)context.getBean(PersistentEntities.class));
        this.backendIdHandlerMethodArgumentResolver = Lazy.of(() -> (BackendIdHandlerMethodArgumentResolver)context.getBean(BackendIdHandlerMethodArgumentResolver.class));
        this.associationLinks = Lazy.of(() -> (Associations)context.getBean(Associations.class));
        this.enumTranslator = Lazy.of(() -> (EnumTranslator)context.getBean(EnumTranslator.class));
        this.serverHttpRequestMethodArgumentResolver = Lazy.of(() -> (ServerHttpRequestMethodArgumentResolver)context.getBean(ServerHttpRequestMethodArgumentResolver.class));
        this.eTagArgumentResolver = Lazy.of(() -> (ETagArgumentResolver)context.getBean(ETagArgumentResolver.class));
        this.repositoryInvokerFactory = Lazy.of(() -> new UnwrappingRepositoryInvokerFactory((RepositoryInvokerFactory)new DefaultRepositoryInvokerFactory((Repositories)this.repositories.get(), this.defaultConversionService), this.getEntityLookups()));
        this.defaultConversionService = new DefaultFormattingConversionService();
        this.configurerDelegate = Lazy.of(() -> (RepositoryRestConfigurerDelegate)context.getBean(RepositoryRestConfigurerDelegate.class));
        this.repositoryRestConfiguration = Lazy.of(() -> (RepositoryRestConfiguration)context.getBean(RepositoryRestConfiguration.class));
        this.pageableResolver = Lazy.of(() -> (HateoasPageableHandlerMethodArgumentResolver)context.getBean(HateoasPageableHandlerMethodArgumentResolver.class));
        this.sortResolver = Lazy.of(() -> (HateoasSortHandlerMethodArgumentResolver)context.getBean(HateoasSortHandlerMethodArgumentResolver.class));
    }

    @Bean
    public static RepositoryRestConfigurerDelegate configurerDelegate(List<RepositoryRestConfigurer> configurers) {
        return new RepositoryRestConfigurerDelegate(configurers);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Bean
    public Repositories repositories() {
        return new Repositories((ListableBeanFactory)this.applicationContext);
    }

    @Bean
    public RepositoryRelProvider repositoryRelProvider(ObjectFactory<ResourceMappings> resourceMappings) {
        return new RepositoryRelProvider(resourceMappings);
    }

    @Bean
    public PersistentEntities persistentEntities() {
        ArrayList<MappingContext> arrayList = new ArrayList<MappingContext>();
        for (MappingContext context : BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, MappingContext.class).values()) {
            arrayList.add(context);
        }
        return new PersistentEntities(arrayList);
    }

    @Bean
    @Qualifier
    public DefaultFormattingConversionService defaultConversionService(PersistentEntities persistentEntities, RepositoryInvokerFactory repositoryInvokerFactory, Repositories repositories, RepositoryRestConfigurerDelegate configurerDelegate) {
        DefaultFormattingConversionService conversionService = (DefaultFormattingConversionService)this.defaultConversionService;
        conversionService.addConverter((GenericConverter)new UriToEntityConverter(persistentEntities, repositoryInvokerFactory, repositories));
        conversionService.addConverter((Converter)StringToLdapNameConverter.INSTANCE);
        this.addFormatters((FormatterRegistry)conversionService);
        configurerDelegate.configureConversionService((ConfigurableConversionService)conversionService);
        return conversionService;
    }

    @Bean
    public ValidatingRepositoryEventListener validatingRepositoryEventListener(ObjectFactory<PersistentEntities> entities, RepositoryRestConfigurerDelegate configurerDelegate) {
        ValidatingRepositoryEventListener listener = new ValidatingRepositoryEventListener(entities);
        configurerDelegate.configureValidatingRepositoryEventListener(listener);
        return listener;
    }

    @Bean
    public JpaHelper jpaHelper() {
        if (IS_JPA_AVAILABLE) {
            return new JpaHelper();
        }
        return null;
    }

    @Bean
    public <T extends RepositoryRestConfiguration> T repositoryRestConfiguration() {
        ProjectionDefinitionConfiguration configuration = new ProjectionDefinitionConfiguration();
        for (Class<?> projection : this.getProjections((Repositories)this.repositories.get())) {
            configuration.addProjection(projection);
        }
        RepositoryCorsRegistry registry = new RepositoryCorsRegistry();
        WebMvcRepositoryRestConfiguration config = new WebMvcRepositoryRestConfiguration(configuration, new MetadataConfiguration(), new EnumTranslator(MessageResolver.DEFAULTS_ONLY), registry);
        ((RepositoryRestConfigurerDelegate)this.configurerDelegate.get()).configureRepositoryRestConfiguration(config, (CorsRegistry)registry);
        return (T)config;
    }

    @Bean
    public static ProjectionDefinitionRegistar projectionDefinitionRegistrar(ObjectFactory<RepositoryRestConfiguration> config) {
        return new ProjectionDefinitionRegistar(config);
    }

    @Bean
    public MetadataConfiguration metadataConfiguration() {
        return new MetadataConfiguration();
    }

    @Bean
    public BaseUri baseUri(RepositoryRestConfiguration repositoryRestConfiguration) {
        return new BaseUri(repositoryRestConfiguration.getBasePath());
    }

    @Bean
    public static AnnotatedEventHandlerInvoker annotatedEventHandlerInvoker() {
        return new AnnotatedEventHandlerInvoker();
    }

    @Bean
    public ServerHttpRequestMethodArgumentResolver serverHttpRequestMethodArgumentResolver() {
        return new ServerHttpRequestMethodArgumentResolver();
    }

    @Bean
    public RootResourceInformationHandlerMethodArgumentResolver repoRequestArgumentResolver(Repositories repositories, ResourceMetadataHandlerMethodArgumentResolver resourceMetadataHandlerMethodArgumentResolver, @Qualifier RepositoryInvokerFactory repositoryInvokerFactory) {
        if (QuerydslUtils.QUERY_DSL_PRESENT) {
            QuerydslBindingsFactory factory = (QuerydslBindingsFactory)this.applicationContext.getBean(QuerydslBindingsFactory.class);
            QuerydslPredicateBuilder predicateBuilder = new QuerydslPredicateBuilder(this.defaultConversionService, factory.getEntityPathResolver());
            return new QuerydslAwareRootResourceInformationHandlerMethodArgumentResolver(repositories, repositoryInvokerFactory, resourceMetadataHandlerMethodArgumentResolver, predicateBuilder, factory);
        }
        return new RootResourceInformationHandlerMethodArgumentResolver(repositories, repositoryInvokerFactory, resourceMetadataHandlerMethodArgumentResolver);
    }

    @Bean
    public ResourceMetadataHandlerMethodArgumentResolver resourceMetadataHandlerMethodArgumentResolver(Repositories repositories, RepositoryResourceMappings resourceMappings, BaseUri baseUri) {
        return new ResourceMetadataHandlerMethodArgumentResolver(repositories, (ResourceMappings)resourceMappings, baseUri);
    }

    @Bean
    public BackendIdHandlerMethodArgumentResolver backendIdHandlerMethodArgumentResolver(PluginRegistry<BackendIdConverter, Class<?>> backendIdConverterRegistry, ResourceMetadataHandlerMethodArgumentResolver resourceMetadataHandlerMethodArgumentResolver, BaseUri baseUri) {
        return new BackendIdHandlerMethodArgumentResolver(backendIdConverterRegistry, resourceMetadataHandlerMethodArgumentResolver, baseUri);
    }

    @Bean
    public ETagArgumentResolver eTagArgumentResolver() {
        return new ETagArgumentResolver();
    }

    @Bean
    public RepositoryEntityLinks entityLinks(ObjectFactory<HateoasPageableHandlerMethodArgumentResolver> pageableResolver, Repositories repositories, RepositoryResourceMappings resourceMappings, PluginRegistry<BackendIdConverter, Class<?>> backendIdConverterRegistry, RepositoryRestConfiguration repositoryRestConfiguration, ObjectFactory<HateoasSortHandlerMethodArgumentResolver> sortResolver) {
        Lazy templateVariables = Lazy.of(() -> new ArgumentResolverPagingAndSortingTemplateVariables((HateoasPageableHandlerMethodArgumentResolver)pageableResolver.getObject(), (HateoasSortHandlerMethodArgumentResolver)sortResolver.getObject()));
        return new RepositoryEntityLinks(repositories, (ResourceMappings)resourceMappings, repositoryRestConfiguration, (Lazy<PagingAndSortingTemplateVariables>)templateVariables, backendIdConverterRegistry);
    }

    @Bean
    public PersistentEntityResourceHandlerMethodArgumentResolver persistentEntityArgumentResolver(@Qualifier(value="defaultMessageConverters") List<HttpMessageConverter<?>> defaultMessageConverters, RootResourceInformationHandlerMethodArgumentResolver repoRequestArgumentResolver, Associations associationLinks, BackendIdHandlerMethodArgumentResolver backendIdHandlerMethodArgumentResolver, PersistentEntities persistentEntities) {
        PluginRegistry lookups = PluginRegistry.of(this.getEntityLookups());
        return new PersistentEntityResourceHandlerMethodArgumentResolver(defaultMessageConverters, repoRequestArgumentResolver, backendIdHandlerMethodArgumentResolver, new DomainObjectReader(persistentEntities, associationLinks), lookups);
    }

    @Bean
    public PersistentEntityToJsonSchemaConverter jsonSchemaConverter(PersistentEntities persistentEntities, Associations associationLinks, @Qualifier RepositoryInvokerFactory repositoryInvokerFactory, RepositoryRestConfiguration repositoryRestConfiguration) {
        return new PersistentEntityToJsonSchemaConverter(persistentEntities, associationLinks, (MessageResolver)this.resolver.getObject(), this.objectMapper(), repositoryRestConfiguration, new PersistentEntityToJsonSchemaConverter.ValueTypeSchemaPropertyCustomizerFactory(repositoryInvokerFactory));
    }

    public ObjectMapper objectMapper() {
        return (ObjectMapper)this.mapper.get();
    }

    @Bean
    public TypeConstrainedMappingJackson2HttpMessageConverter jacksonHttpMessageConverter(RepositoryRestConfiguration repositoryRestConfiguration) {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        if (!repositoryRestConfiguration.useHalAsDefaultJsonMediaType()) {
            mediaTypes.add(MediaType.APPLICATION_JSON);
        }
        int order = repositoryRestConfiguration.useHalAsDefaultJsonMediaType() ? 0x7FFFFFFE : 0x7FFFFFF5;
        mediaTypes.addAll(Arrays.asList(RestMediaTypes.SCHEMA_JSON, RestMediaTypes.JSON_PATCH_JSON, RestMediaTypes.MERGE_PATCH_JSON, RestMediaTypes.SPRING_DATA_VERBOSE_JSON, RestMediaTypes.SPRING_DATA_COMPACT_JSON));
        ResourceSupportHttpMessageConverter jacksonConverter = new ResourceSupportHttpMessageConverter(order);
        jacksonConverter.setObjectMapper(this.objectMapper());
        jacksonConverter.setSupportedMediaTypes(mediaTypes);
        return jacksonConverter;
    }

    @Bean
    public TypeConstrainedMappingJackson2HttpMessageConverter halJacksonHttpMessageConverter(LinkCollector linkCollector, RepositoryRestConfiguration repositoryRestConfiguration) {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        mediaTypes.add(MediaTypes.HAL_JSON);
        if (repositoryRestConfiguration.useHalAsDefaultJsonMediaType()) {
            mediaTypes.add(MediaType.APPLICATION_JSON);
        }
        int order = repositoryRestConfiguration.useHalAsDefaultJsonMediaType() ? 0x7FFFFFF5 : 0x7FFFFFFE;
        ResourceSupportHttpMessageConverter converter = new ResourceSupportHttpMessageConverter(order);
        converter.setObjectMapper(this.halObjectMapper(linkCollector));
        converter.setSupportedMediaTypes(mediaTypes);
        return converter;
    }

    public ObjectMapper halObjectMapper(LinkCollector linkCollector) {
        LinkRelationProvider defaultedRelProvider = (LinkRelationProvider)this.relProvider.getIfUnique(EvoInflectorLinkRelationProvider::new);
        HalConfiguration halConfiguration = (HalConfiguration)this.halConfiguration.getIfUnique(HalConfiguration::new);
        Jackson2HalModule.HalHandlerInstantiator instantiator = new Jackson2HalModule.HalHandlerInstantiator(defaultedRelProvider, (CurieProvider)this.curieProvider.getIfUnique(() -> new DefaultCurieProvider(Collections.emptyMap())), (MessageResolver)this.resolver.getObject(), halConfiguration);
        ObjectMapper mapper = this.basicObjectMapper();
        mapper.registerModule(this.persistentEntityJackson2Module(linkCollector));
        mapper.registerModule((Module)new Jackson2HalModule());
        mapper.setHandlerInstantiator((HandlerInstantiator)instantiator);
        return mapper;
    }

    @Bean
    public UriListHttpMessageConverter uriListHttpMessageConverter() {
        return new UriListHttpMessageConverter();
    }

    @Bean
    public RequestMappingHandlerAdapter repositoryExporterHandlerAdapter(@Qualifier(value="defaultMessageConverters") List<HttpMessageConverter<?>> defaultMessageConverters, AlpsJsonHttpMessageConverter alpsJsonHttpMessageConverter, SelfLinkProvider selfLinkProvider, PersistentEntityResourceHandlerMethodArgumentResolver persistentEntityArgumentResolver, RootResourceInformationHandlerMethodArgumentResolver repoRequestArgumentResolver, RepositoryRestConfiguration repositoryRestConfiguration) {
        ConfigurableWebBindingInitializer initializer = new ConfigurableWebBindingInitializer();
        initializer.setConversionService(this.defaultConversionService);
        RepositoryRestHandlerAdapter handlerAdapter = new RepositoryRestHandlerAdapter(this.defaultMethodArgumentResolvers(selfLinkProvider, persistentEntityArgumentResolver, repoRequestArgumentResolver));
        handlerAdapter.setWebBindingInitializer((WebBindingInitializer)initializer);
        handlerAdapter.setMessageConverters(defaultMessageConverters);
        if (repositoryRestConfiguration.getMetadataConfiguration().alpsEnabled()) {
            handlerAdapter.setResponseBodyAdvice(Arrays.asList(new ResponseBodyAdvice[]{alpsJsonHttpMessageConverter}));
        }
        return handlerAdapter;
    }

    @Bean
    public DelegatingHandlerMapping restHandlerMapping(Repositories repositories, RepositoryResourceMappings resourceMappings, Optional<JpaHelper> jpaHelper, RepositoryRestConfiguration repositoryRestConfiguration, CorsConfigurationAware corsRestConfiguration) {
        Map<String, CorsConfiguration> corsConfigurations = corsRestConfiguration.getCorsConfigurations();
        PathPatternParser parser = (PathPatternParser)this.parser.getIfAvailable();
        RepositoryRestHandlerMapping repositoryMapping = new RepositoryRestHandlerMapping((ResourceMappings)resourceMappings, repositoryRestConfiguration, repositories);
        repositoryMapping.setJpaHelper(jpaHelper.orElse(null));
        repositoryMapping.setApplicationContext(this.applicationContext);
        repositoryMapping.setCorsConfigurations(corsConfigurations);
        repositoryMapping.setPatternParser(parser);
        repositoryMapping.afterPropertiesSet();
        BasePathAwareHandlerMapping basePathMapping = new BasePathAwareHandlerMapping(repositoryRestConfiguration);
        basePathMapping.setApplicationContext(this.applicationContext);
        basePathMapping.setCorsConfigurations(corsConfigurations);
        basePathMapping.setPatternParser(parser);
        basePathMapping.afterPropertiesSet();
        ArrayList<HandlerMapping> mappings = new ArrayList<HandlerMapping>();
        mappings.add((HandlerMapping)basePathMapping);
        mappings.add((HandlerMapping)repositoryMapping);
        return new DelegatingHandlerMapping(mappings, parser);
    }

    @Bean
    public RepositoryResourceMappings resourceMappings(Repositories repositories, PersistentEntities persistentEntities, RepositoryRestConfiguration repositoryRestConfiguration) {
        return new RepositoryResourceMappings(repositories, persistentEntities, repositoryRestConfiguration);
    }

    protected Module persistentEntityJackson2Module(LinkCollector linkCollector) {
        EmbeddedResourcesAssembler assembler = new EmbeddedResourcesAssembler((PersistentEntities)this.persistentEntities.get(), (Associations)this.associationLinks.get(), (ExcerptProjector)this.excerptProjector.get());
        PersistentEntityJackson2Module.LookupObjectSerializer lookupObjectSerializer = new PersistentEntityJackson2Module.LookupObjectSerializer(PluginRegistry.of(this.getEntityLookups()));
        return new PersistentEntityJackson2Module((Associations)this.associationLinks.get(), (PersistentEntities)this.persistentEntities.get(), new UriToEntityConverter((PersistentEntities)this.persistentEntities.get(), (RepositoryInvokerFactory)this.repositoryInvokerFactory.get(), (Repositories)this.repositories.get()), linkCollector, (RepositoryInvokerFactory)this.repositoryInvokerFactory.get(), lookupObjectSerializer, (RepresentationModelProcessorInvoker)this.invoker.getObject(), assembler);
    }

    @Bean
    protected LinkCollector linkCollector(PersistentEntities persistentEntities, SelfLinkProvider selfLinkProvider, Associations associationLinks) {
        return new LinkCollector(persistentEntities, selfLinkProvider, associationLinks);
    }

    @Bean
    public ExcerptProjector excerptProjector(RepositoryResourceMappings resourceMappings) {
        SpelAwareProxyProjectionFactory projectionFactory = new SpelAwareProxyProjectionFactory();
        projectionFactory.setBeanFactory((BeanFactory)this.applicationContext);
        return new DefaultExcerptProjector((ProjectionFactory)projectionFactory, (ResourceMappings)resourceMappings);
    }

    public void extendHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
        ExceptionHandlerExceptionResolver er = new ExceptionHandlerExceptionResolver();
        er.setCustomArgumentResolvers(this.defaultMethodArgumentResolvers((SelfLinkProvider)this.selfLinkProvider.get(), (PersistentEntityResourceHandlerMethodArgumentResolver)this.persistentEntityArgumentResolver.get(), (RootResourceInformationHandlerMethodArgumentResolver)this.repoRequestArgumentResolver.get()));
        er.setMessageConverters(this.defaultMessageConverters);
        ((RepositoryRestConfigurerDelegate)this.configurerDelegate.get()).configureExceptionHandlerExceptionResolver(er);
        er.afterPropertiesSet();
        exceptionResolvers.add(0, (HandlerExceptionResolver)er);
    }

    @Bean
    public RepositoryRestExceptionHandler repositoryRestExceptionHandler() {
        return new RepositoryRestExceptionHandler((MessageSource)this.applicationContext);
    }

    @Bean
    @Qualifier
    public RepositoryInvokerFactory repositoryInvokerFactory() {
        return new UnwrappingRepositoryInvokerFactory((RepositoryInvokerFactory)new DefaultRepositoryInvokerFactory((Repositories)this.repositories.get(), this.defaultConversionService), this.getEntityLookups());
    }

    @Bean
    public List<HttpMessageConverter<?>> defaultMessageConverters(@Qualifier(value="jacksonHttpMessageConverter") TypeConstrainedMappingJackson2HttpMessageConverter jacksonHttpMessageConverter, @Qualifier(value="halJacksonHttpMessageConverter") TypeConstrainedMappingJackson2HttpMessageConverter halJacksonHttpMessageConverter, AlpsJsonHttpMessageConverter alpsJsonHttpMessageConverter, UriListHttpMessageConverter uriListHttpMessageConverter, RepositoryRestConfigurerDelegate configurerDelegate, RepositoryRestConfiguration repositoryRestConfiguration) {
        ArrayList messageConverters = new ArrayList();
        if (repositoryRestConfiguration.getMetadataConfiguration().alpsEnabled()) {
            messageConverters.add((HttpMessageConverter<?>)alpsJsonHttpMessageConverter);
        }
        if (repositoryRestConfiguration.getDefaultMediaType().equals((Object)MediaTypes.HAL_JSON)) {
            messageConverters.add((HttpMessageConverter<?>)halJacksonHttpMessageConverter);
            messageConverters.add((HttpMessageConverter<?>)jacksonHttpMessageConverter);
        } else {
            messageConverters.add((HttpMessageConverter<?>)jacksonHttpMessageConverter);
            messageConverters.add((HttpMessageConverter<?>)halJacksonHttpMessageConverter);
        }
        MappingJackson2HttpMessageConverter fallbackJsonConverter = new MappingJackson2HttpMessageConverter();
        fallbackJsonConverter.setObjectMapper(this.basicObjectMapper());
        messageConverters.add((HttpMessageConverter<?>)fallbackJsonConverter);
        messageConverters.add(uriListHttpMessageConverter);
        configurerDelegate.configureHttpMessageConverters(messageConverters);
        return messageConverters;
    }

    @Bean
    public AlpsJsonHttpMessageConverter alpsJsonHttpMessageConverter(RootResourceInformationToAlpsDescriptorConverter alpsConverter) {
        return new AlpsJsonHttpMessageConverter(alpsConverter);
    }

    @Bean
    public HateoasPageableHandlerMethodArgumentResolver pageableResolver() {
        HateoasPageableHandlerMethodArgumentResolver resolver = super.pageableResolver();
        resolver.setPageParameterName(((RepositoryRestConfiguration)this.repositoryRestConfiguration.get()).getPageParamName());
        resolver.setSizeParameterName(((RepositoryRestConfiguration)this.repositoryRestConfiguration.get()).getLimitParamName());
        resolver.setFallbackPageable((Pageable)PageRequest.of((int)0, (int)((RepositoryRestConfiguration)this.repositoryRestConfiguration.get()).getDefaultPageSize()));
        resolver.setMaxPageSize(((RepositoryRestConfiguration)this.repositoryRestConfiguration.get()).getMaxPageSize());
        return resolver;
    }

    @Bean
    public HateoasSortHandlerMethodArgumentResolver sortResolver() {
        HateoasSortHandlerMethodArgumentResolver resolver = super.sortResolver();
        resolver.setSortParameter(((RepositoryRestConfiguration)this.repositoryRestConfiguration.get()).getSortParamName());
        return resolver;
    }

    @Bean
    public PluginRegistry<BackendIdConverter, Class<?>> backendIdConverterRegistry() {
        ArrayList<BackendIdConverter> converters = new ArrayList<BackendIdConverter>(this.idConverters.size());
        converters.addAll(this.idConverters);
        converters.add(BackendIdConverter.DefaultIdConverter.INSTANCE);
        return PluginRegistry.of(converters);
    }

    @Bean
    public AuditableBeanWrapperFactory auditableBeanWrapperFactory(PersistentEntities persistentEntities) {
        return new MappingAuditableBeanWrapperFactory(persistentEntities);
    }

    @Bean
    public HttpHeadersPreparer httpHeadersPreparer(AuditableBeanWrapperFactory auditableBeanWrapperFactory) {
        return new HttpHeadersPreparer(auditableBeanWrapperFactory);
    }

    @Bean
    public SelfLinkProvider selfLinkProvider(PersistentEntities persistentEntities, RepositoryEntityLinks entityLinks, @Qualifier(value="mvcConversionService") ObjectProvider<ConversionService> conversionService) {
        return new DefaultSelfLinkProvider(persistentEntities, (EntityLinks)entityLinks, this.getEntityLookups(), (ConversionService)conversionService.getIfUnique(() -> this.defaultConversionService));
    }

    @Bean
    public Associations associationLinks(RepositoryResourceMappings resourceMappings, RepositoryRestConfiguration repositoryRestConfiguration) {
        return new Associations((ResourceMappings)resourceMappings, repositoryRestConfiguration);
    }

    protected List<EntityLookup<?>> getEntityLookups() {
        ArrayList lookups = new ArrayList();
        lookups.addAll(((RepositoryRestConfiguration)this.repositoryRestConfiguration.get()).getEntityLookups((Repositories)this.repositories.get()));
        lookups.addAll(this.lookups);
        return lookups;
    }

    protected List<HandlerMethodArgumentResolver> defaultMethodArgumentResolvers(SelfLinkProvider selfLinkProvider, PersistentEntityResourceHandlerMethodArgumentResolver persistentEntityArgumentResolver, RootResourceInformationHandlerMethodArgumentResolver repoRequestArgumentResolver) {
        SpelAwareProxyProjectionFactory projectionFactory = new SpelAwareProxyProjectionFactory();
        projectionFactory.setBeanFactory((BeanFactory)this.applicationContext);
        projectionFactory.setBeanClassLoader(this.beanClassLoader);
        JacksonMappingAwareSortTranslator sortTranslator = new JacksonMappingAwareSortTranslator(this.objectMapper(), (Repositories)this.repositories.get(), DomainClassResolver.of((Repositories)this.repositories.get(), (ResourceMappings)this.resourceMappings.get(), (BaseUri)this.baseUri.get()), (PersistentEntities)this.persistentEntities.get(), (Associations)this.associationLinks.get());
        return Arrays.asList(new HandlerMethodArgumentResolver[]{new MappingAwareDefaultedPageableArgumentResolver(sortTranslator, (PageableHandlerMethodArgumentResolver)this.pageableResolver.get()), new MappingAwarePageableArgumentResolver(sortTranslator, (PageableArgumentResolver)this.pageableResolver.get()), new MappingAwareSortArgumentResolver(sortTranslator, (SortArgumentResolver)this.sortResolver.get()), (HandlerMethodArgumentResolver)this.serverHttpRequestMethodArgumentResolver.get(), repoRequestArgumentResolver, persistentEntityArgumentResolver, (HandlerMethodArgumentResolver)this.resourceMetadataHandlerMethodArgumentResolver.get(), HttpMethodHandlerMethodArgumentResolver.INSTANCE, new PersistentEntityResourceAssemblerArgumentResolver((PersistentEntities)this.persistentEntities.get(), selfLinkProvider, (ProjectionDefinitions)((RepositoryRestConfiguration)this.repositoryRestConfiguration.get()).getProjectionConfiguration(), (ProjectionFactory)projectionFactory, (Associations)this.associationLinks.get()), (HandlerMethodArgumentResolver)this.backendIdHandlerMethodArgumentResolver.get(), (HandlerMethodArgumentResolver)this.eTagArgumentResolver.get()});
    }

    protected ObjectMapper basicObjectMapper() {
        ObjectMapper mapper = (ObjectMapper)this.objectMapper.getIfAvailable();
        ObjectMapper objectMapper = mapper == null ? new ObjectMapper() : mapper.copy();
        objectMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ((RepositoryRestConfigurerDelegate)this.configurerDelegate.get()).configureJacksonObjectMapper(objectMapper);
        objectMapper.registerModule((Module)this.geoModule.getObject());
        if (((RepositoryRestConfiguration)this.repositoryRestConfiguration.get()).isEnableEnumTranslation()) {
            objectMapper.registerModule((Module)new JacksonSerializers((EnumTranslator)this.enumTranslator.get()));
        }
        Jackson2DatatypeHelper.configureObjectMapper(objectMapper);
        return objectMapper;
    }

    @Bean
    public EnumTranslator enumTranslator(MessageResolver resolver) {
        return new EnumTranslator(resolver);
    }

    private Set<Class<?>> getProjections(Repositories repositories) {
        HashSet<String> packagesToScan = new HashSet<String>();
        for (Class domainType : repositories) {
            packagesToScan.add(domainType.getPackage().getName());
        }
        AnnotatedTypeScanner scanner = new AnnotatedTypeScanner(new Class[]{Projection.class});
        scanner.setEnvironment(this.applicationContext.getEnvironment());
        scanner.setResourceLoader((ResourceLoader)this.applicationContext);
        return scanner.findTypes(packagesToScan);
    }

    @Bean
    public RootResourceInformationToAlpsDescriptorConverter alpsConverter(Repositories repositories, PersistentEntities persistentEntities, RepositoryEntityLinks entityLinks, EnumTranslator enumTranslator, Associations associationLinks, RepositoryRestConfiguration repositoryRestConfiguration) {
        return new RootResourceInformationToAlpsDescriptorConverter(associationLinks, repositories, persistentEntities, (EntityLinks)entityLinks, (MessageResolver)this.resolver.getObject(), repositoryRestConfiguration, this.objectMapper(), enumTranslator);
    }

    @Bean
    public ProfileResourceProcessor profileResourceProcessor(RepositoryRestConfiguration repositoryRestConfiguration) {
        return new ProfileResourceProcessor(repositoryRestConfiguration);
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        SpringFactoriesLoader.loadFactories(StaticResourceProvider.class, (ClassLoader)this.beanClassLoader).forEach(it -> it.customizeResources(registry, (RepositoryRestConfiguration)this.repositoryRestConfiguration.get()));
    }

    private static class ResourceSupportHttpMessageConverter
    extends TypeConstrainedMappingJackson2HttpMessageConverter
    implements Ordered {
        private final int order;

        public ResourceSupportHttpMessageConverter(int order) {
            super(RepresentationModel.class);
            this.order = order;
        }

        public int getOrder() {
            return this.order;
        }
    }
}

