/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.hash;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.redis.hash.HashMapper;
import org.springframework.data.util.DirectFieldAccessFallbackBeanWrapper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Jackson2HashMapper
implements HashMapper<Object, String, Object> {
    private final ObjectMapper typingMapper;
    private final ObjectMapper untypedMapper;
    private final boolean flatten;

    public Jackson2HashMapper(boolean flatten) {
        this(new ObjectMapper(), flatten);
        this.typingMapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        this.typingMapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        this.typingMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.typingMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public Jackson2HashMapper(ObjectMapper mapper, boolean flatten) {
        Assert.notNull((Object)mapper, (String)"Mapper must not be null!");
        this.typingMapper = mapper;
        this.flatten = flatten;
        this.untypedMapper = new ObjectMapper();
        this.untypedMapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        this.untypedMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Override
    public Map<String, Object> toHash(Object source) {
        JsonNode tree = this.typingMapper.valueToTree(source);
        return this.flatten ? this.flattenMap(tree.fields()) : (Map)this.untypedMapper.convertValue((Object)tree, Map.class);
    }

    @Override
    public Object fromHash(Map<String, Object> hash) {
        try {
            if (this.flatten) {
                return this.typingMapper.reader().forType(Object.class).readValue(this.untypedMapper.writeValueAsBytes(this.doUnflatten(hash)));
            }
            return this.typingMapper.treeToValue((TreeNode)this.untypedMapper.valueToTree(hash), Object.class);
        }
        catch (JsonParseException e) {
            throw new MappingException(e.getMessage(), (Throwable)e);
        }
        catch (JsonMappingException e) {
            throw new MappingException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new MappingException(e.getMessage(), (Throwable)e);
        }
    }

    private Map<String, Object> doUnflatten(Map<String, Object> source) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        LinkedHashSet<String> treatSeperate = new LinkedHashSet<String>();
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String key = entry.getKey();
            String[] args = key.split("\\.");
            if (args.length == 1 && !args[0].contains("[")) {
                result.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (args.length == 1 && ((String)args[0]).contains("[")) {
                String string = ((String)args[0]).substring(0, ((String)args[0]).indexOf(91));
                if (result.containsKey(string)) {
                    this.appendValueToTypedList((String)args[0], entry.getValue(), (List)result.get(string));
                    continue;
                }
                result.put(string, this.createTypedListWithValue(entry.getValue()));
                continue;
            }
            treatSeperate.add(key.substring(0, key.indexOf(46)));
        }
        for (String partial : treatSeperate) {
            LinkedHashMap<String, Object> newSource = new LinkedHashMap<String, Object>();
            for (Map.Entry entry : source.entrySet()) {
                if (!((String)entry.getKey()).startsWith(partial)) continue;
                newSource.put(((String)entry.getKey()).substring(partial.length() + 1), entry.getValue());
            }
            if (partial.endsWith("]")) {
                String prunedKey = partial.substring(0, partial.indexOf(91));
                if (result.containsKey(prunedKey)) {
                    this.appendValueToTypedList(partial, this.doUnflatten(newSource), (List)result.get(prunedKey));
                    continue;
                }
                result.put(prunedKey, this.createTypedListWithValue(this.doUnflatten(newSource)));
                continue;
            }
            result.put(partial, this.doUnflatten(newSource));
        }
        return result;
    }

    private Map<String, Object> flattenMap(Iterator<Map.Entry<String, JsonNode>> source) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        this.doFlatten("", source, resultMap);
        return resultMap;
    }

    private void doFlatten(String propertyPrefix, Iterator<Map.Entry<String, JsonNode>> inputMap, Map<String, Object> resultMap) {
        if (StringUtils.hasText((String)propertyPrefix)) {
            propertyPrefix = propertyPrefix + ".";
        }
        while (inputMap.hasNext()) {
            Map.Entry<String, JsonNode> entry = inputMap.next();
            this.flattenElement(propertyPrefix + entry.getKey(), entry.getValue(), resultMap);
        }
    }

    private void flattenElement(String propertyPrefix, Object source, Map<String, Object> resultMap) {
        if (!(source instanceof JsonNode)) {
            resultMap.put(propertyPrefix, source);
            return;
        }
        JsonNode element = (JsonNode)source;
        if (element.isArray()) {
            Iterator nodes = element.elements();
            while (nodes.hasNext()) {
                JsonNode cur = (JsonNode)nodes.next();
                if (!cur.isArray()) continue;
                this.falttenCollection(propertyPrefix, cur.elements(), resultMap);
            }
        } else if (element.isContainerNode()) {
            this.doFlatten(propertyPrefix, element.fields(), resultMap);
        } else {
            resultMap.put(propertyPrefix, new DirectFieldAccessFallbackBeanWrapper((Object)element).getPropertyValue("_value"));
        }
    }

    private void falttenCollection(String propertyPrefix, Iterator<JsonNode> list, Map<String, Object> resultMap) {
        int counter = 0;
        while (list.hasNext()) {
            JsonNode element = list.next();
            this.flattenElement(propertyPrefix + "[" + counter + "]", element, resultMap);
            ++counter;
        }
    }

    private void appendValueToTypedList(String key, Object value, List<Object> destination) {
        int index = Integer.valueOf(key.substring(key.indexOf(91) + 1, key.length() - 1));
        List resultList = (List)destination.get(1);
        if (resultList.size() < index) {
            resultList.add(value);
        } else {
            resultList.add(index, value);
        }
    }

    private List<Object> createTypedListWithValue(Object value) {
        ArrayList<Object> listWithTypeHint = new ArrayList<Object>();
        listWithTypeHint.add(ArrayList.class.getName());
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(value);
        listWithTypeHint.add(values);
        return listWithTypeHint;
    }
}

