/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Map;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.mapping.RelationshipInfo;
import org.springframework.data.neo4j.repository.query.QueryTemplates;
import org.springframework.data.neo4j.repository.query.VariableContext;
import org.springframework.data.repository.query.Parameter;

class MatchClause {
    private final PersistentPropertyPath<Neo4jPersistentProperty> path;

    public MatchClause(PersistentPropertyPath<Neo4jPersistentProperty> path) {
        this.path = this.relationshipPath(path);
    }

    private PersistentPropertyPath<Neo4jPersistentProperty> relationshipPath(PersistentPropertyPath<Neo4jPersistentProperty> path) {
        return path.getLength() == 1 || ((Neo4jPersistentProperty)path.getLeafProperty()).isRelationship() ? path : this.relationshipPath((PersistentPropertyPath<Neo4jPersistentProperty>)path.getParentPath());
    }

    public boolean hasRelationship() {
        for (Neo4jPersistentProperty property : this.path) {
            if (!property.isRelationship()) continue;
            return true;
        }
        return false;
    }

    public String toString(VariableContext variableContext) {
        return this.matchPattern(variableContext, this.path);
    }

    private String matchPattern(VariableContext variableContext, PersistentPropertyPath<Neo4jPersistentProperty> relPath) {
        if (relPath.getLength() == 1) {
            Neo4jPersistentProperty property = (Neo4jPersistentProperty)relPath.getBaseProperty();
            return this.formatMatch(variableContext.getVariableFor(property.getOwner()), QueryTemplates.getArrow(property.getRelationshipInfo()), variableContext.getVariableFor(relPath));
        }
        RelationshipInfo info = ((Neo4jPersistentProperty)relPath.getLeafProperty()).getRelationshipInfo();
        return this.formatMatch2(this.matchPattern(variableContext, (PersistentPropertyPath<Neo4jPersistentProperty>)relPath.getParentPath()), QueryTemplates.getArrow(info), variableContext.getVariableFor(relPath));
    }

    private String formatMatch(String first, String arrow, String second) {
        return String.format("`%s`%s`%s`", first, arrow, second);
    }

    private String formatMatch2(String first, String arrow, String second) {
        return String.format("%s%s`%s`", first, arrow, second);
    }

    public Map<Parameter, Object> resolveParameters(Map<Parameter, Object> parameters) {
        return parameters;
    }
}

