/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.springframework.data.neo4j.repository.AbstractGraphRepository;
import org.springframework.data.neo4j.repository.GraphRepository;
import org.springframework.data.neo4j.repository.RelationshipOperationsRepository;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class NodeGraphRepositoryImpl<T>
extends AbstractGraphRepository<Node, T>
implements GraphRepository<T>,
RelationshipOperationsRepository<T> {
    public NodeGraphRepositoryImpl(Class<T> clazz, Neo4jTemplate template) {
        super(template, clazz);
    }

    @Override
    protected Node getById(long id) {
        return this.template.getNode(id);
    }

    @Override
    public <N> Iterable<T> findAllByTraversal(N start, TraversalDescription traversalDescription) {
        return this.template.traverse(start, this.clazz, traversalDescription);
    }

    @Override
    public <R> R createRelationshipBetween(T start, Object end, Class<R> relationshipEntityClass, String relationshipType) {
        return this.template.createRelationshipBetween(start, end, relationshipEntityClass, relationshipType, false);
    }

    @Override
    public <R> R createDuplicateRelationshipBetween(T start, Object end, Class<R> relationshipEntityClass, String relationshipType) {
        return this.template.createRelationshipBetween(start, end, relationshipEntityClass, relationshipType, true);
    }

    @Override
    public <R> R getRelationshipBetween(T start, Object end, Class<R> relationshipEntityClass, String relationshipType) {
        return this.template.getRelationshipBetween(start, end, relationshipEntityClass, relationshipType);
    }

    @Override
    public void deleteRelationshipBetween(T start, Object end, String type) {
        this.template.deleteRelationshipBetween(start, end, type);
    }
}

