/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.RelationshipType;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.RelatedToCollectionFieldAccessorFactory;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.mapping.RelationshipInfo;
import org.springframework.data.neo4j.support.Neo4jTemplate;

public class ReadOnlyRelatedToCollectionFieldAccessorFactory
implements FieldAccessorFactory {
    protected Neo4jTemplate template;

    public ReadOnlyRelatedToCollectionFieldAccessorFactory(Neo4jTemplate template) {
        this.template = template;
    }

    @Override
    public boolean accept(Neo4jPersistentProperty property) {
        if (!property.isRelationship()) {
            return false;
        }
        RelationshipInfo info = property.getRelationshipInfo();
        return info.isCollection() && info.isRelatedTo() && info.isReadonly();
    }

    @Override
    public FieldAccessor forField(Neo4jPersistentProperty property) {
        RelationshipInfo relationshipInfo = property.getRelationshipInfo();
        return new ReadOnlyRelatedToCollectionFieldAccessor(relationshipInfo.getRelationshipType(), relationshipInfo.getDirection(), property.getRelationshipInfo().getTargetType().getType(), this.template, property);
    }

    public static class ReadOnlyRelatedToCollectionFieldAccessor
    extends RelatedToCollectionFieldAccessorFactory.RelatedToCollectionFieldAccessor {
        public ReadOnlyRelatedToCollectionFieldAccessor(RelationshipType type, Direction direction, Class<?> elementClass, Neo4jTemplate template, Neo4jPersistentProperty field) {
            super(type, direction, elementClass, template, field);
        }

        @Override
        public boolean isWriteable(Object entity) {
            return false;
        }

        @Override
        public Object setValue(Object entity, Object newVal, MappingPolicy mappingPolicy) {
            throw new InvalidDataAccessApiUsageException("Cannot set read-only relationship entity field.");
        }

        @Override
        public Object getDefaultValue() {
            return null;
        }
    }
}

