/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.MongoPersistentEntityIndexResolver;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public interface IndexResolver {
    public static IndexResolver create(MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        Assert.notNull(mappingContext, (String)"MongoMappingContext must not be null");
        return new MongoPersistentEntityIndexResolver(mappingContext);
    }

    public Iterable<? extends IndexDefinition> resolveIndexFor(TypeInformation<?> var1);

    default public Iterable<? extends IndexDefinition> resolveIndexFor(Class<?> entityType) {
        return this.resolveIndexFor(TypeInformation.of(entityType));
    }
}

