/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.geo;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.annotation.PersistenceConstructor;
import org.springframework.data.mongodb.core.geo.Distance;
import org.springframework.data.mongodb.core.geo.GeoResult;
import org.springframework.data.mongodb.core.geo.Metric;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoResults<T>
implements Iterable<GeoResult<T>> {
    private final List<GeoResult<T>> results;
    private final Distance averageDistance;

    public GeoResults(List<GeoResult<T>> results) {
        this(results, (Metric)null);
    }

    public GeoResults(List<GeoResult<T>> results, Metric metric) {
        this(results, GeoResults.calculateAverageDistance(results, metric));
    }

    @PersistenceConstructor
    public GeoResults(List<GeoResult<T>> results, Distance averageDistance) {
        Assert.notNull(results);
        this.results = results;
        this.averageDistance = averageDistance;
    }

    public Distance getAverageDistance() {
        return this.averageDistance;
    }

    @Override
    public Iterator<GeoResult<T>> iterator() {
        return this.results.iterator();
    }

    public List<GeoResult<T>> getContent() {
        return Collections.unmodifiableList(this.results);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        GeoResults that = (GeoResults)obj;
        return ((Object)this.results).equals(that.results) && this.averageDistance == that.averageDistance;
    }

    public int hashCode() {
        int result = 17;
        result += 31 * ((Object)this.results).hashCode();
        return result += 31 * this.averageDistance.hashCode();
    }

    public String toString() {
        return String.format("GeoResults: [averageDistance: %s, results: %s]", this.averageDistance.toString(), StringUtils.collectionToCommaDelimitedString(this.results));
    }

    private static Distance calculateAverageDistance(List<? extends GeoResult<?>> results, Metric metric) {
        if (results.isEmpty()) {
            return new Distance(0.0, null);
        }
        double averageDistance = 0.0;
        for (GeoResult<?> result : results) {
            averageDistance += result.getDistance().getValue();
        }
        return new Distance(averageDistance / (double)results.size(), metric);
    }
}

