/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping;

import java.util.Comparator;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.mongodb.MongoCollectionUtils;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicMongoPersistentEntity<T>
extends BasicPersistentEntity<T, MongoPersistentProperty>
implements MongoPersistentEntity<T>,
ApplicationContextAware {
    private final String collection;
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private final StandardEvaluationContext context = new StandardEvaluationContext();

    public BasicMongoPersistentEntity(TypeInformation<T> typeInformation) {
        super(typeInformation, (Comparator)MongoPersistentPropertyComparator.INSTANCE);
        Document d;
        Class rawType = typeInformation.getType();
        String fallback = MongoCollectionUtils.getPreferredCollectionName(rawType);
        this.collection = rawType.isAnnotationPresent(Document.class) ? (StringUtils.hasText((String)(d = rawType.getAnnotation(Document.class)).collection()) ? d.collection() : fallback) : fallback;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
        this.context.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)applicationContext));
        this.context.setRootObject((Object)applicationContext);
    }

    @Override
    public String getCollection() {
        Expression expression = this.parser.parseExpression(this.collection, ParserContext.TEMPLATE_EXPRESSION);
        return (String)expression.getValue((EvaluationContext)this.context, String.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MongoPersistentPropertyComparator implements Comparator<MongoPersistentProperty>
    {
        INSTANCE;


        @Override
        public int compare(MongoPersistentProperty o1, MongoPersistentProperty o2) {
            if (o1.getFieldOrder() == Integer.MAX_VALUE) {
                return 1;
            }
            if (o2.getFieldOrder() == Integer.MAX_VALUE) {
                return -1;
            }
            return o1.getFieldOrder() - o2.getFieldOrder();
        }
    }
}

