/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.types.Binary;
import org.bson.types.ObjectId;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.util.StringUtils;

abstract class MongoConverters {
    private MongoConverters() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BinaryToUUIDConverter implements Converter<Binary, UUID>
    {
        INSTANCE;

        private static final Log LOG;

        public UUID convert(Binary source) {
            if (3 != source.getType()) {
                LOG.warn((Object)String.format("Source binary %s is not an UUID actually! Trying to read it nevertheless...", source.toString()));
            }
            try {
                return source == null ? null : UUID.fromString(new String(source.getData(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new MappingException(String.format("Could not convert Binary %s into UUID!", source.toString()), (Throwable)e);
            }
        }

        static {
            LOG = LogFactory.getLog(BinaryToUUIDConverter.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UUIDToBinaryConverter implements Converter<UUID, Binary>
    {
        INSTANCE;


        public Binary convert(UUID source) {
            try {
                return source == null ? null : new Binary(3, source.toString().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new MappingException(String.format("Could nor convert UUID %s into Binary!", source.toString()), (Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StringToBigIntegerConverter implements Converter<String, BigInteger>
    {
        INSTANCE;


        public BigInteger convert(String source) {
            return StringUtils.hasText((String)source) ? new BigInteger(source) : null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BigIntegerToStringConverter implements Converter<BigInteger, String>
    {
        INSTANCE;


        public String convert(BigInteger source) {
            return source == null ? null : source.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StringToBigDecimalConverter implements Converter<String, BigDecimal>
    {
        INSTANCE;


        public BigDecimal convert(String source) {
            return StringUtils.hasText((String)source) ? new BigDecimal(source) : null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BigDecimalToStringConverter implements Converter<BigDecimal, String>
    {
        INSTANCE;


        public String convert(BigDecimal source) {
            return source == null ? null : source.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BigIntegerToObjectIdConverter implements Converter<BigInteger, ObjectId>
    {
        INSTANCE;


        public ObjectId convert(BigInteger source) {
            return source == null ? null : new ObjectId(source.toString(16));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ObjectIdToBigIntegerConverter implements Converter<ObjectId, BigInteger>
    {
        INSTANCE;


        public BigInteger convert(ObjectId source) {
            return source == null ? null : new BigInteger(source.toString(), 16);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StringToObjectIdConverter implements Converter<String, ObjectId>
    {
        INSTANCE;


        public ObjectId convert(String source) {
            return StringUtils.hasText((String)source) ? new ObjectId(source) : null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ObjectIdToStringConverter implements Converter<ObjectId, String>
    {
        INSTANCE;


        public String convert(ObjectId id) {
            return id == null ? null : id.toString();
        }
    }
}

