/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.data.mongodb.core.CollectionCallback;
import org.springframework.data.mongodb.core.IndexOperations;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexInfo;
import org.springframework.data.mongodb.core.query.Order;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIndexOperations
implements IndexOperations {
    private final MongoOperations mongoOperations;
    private final String collectionName;

    public DefaultIndexOperations(MongoOperations mongoOperations, String collectionName) {
        Assert.notNull((Object)mongoOperations, (String)"MongoOperations must not be null!");
        Assert.notNull((Object)collectionName, (String)"Collection name can not be null!");
        this.mongoOperations = mongoOperations;
        this.collectionName = collectionName;
    }

    @Override
    public void ensureIndex(final IndexDefinition indexDefinition) {
        this.mongoOperations.execute(this.collectionName, new CollectionCallback<Object>(){

            @Override
            public Object doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                DBObject indexOptions = indexDefinition.getIndexOptions();
                if (indexOptions != null) {
                    collection.ensureIndex(indexDefinition.getIndexKeys(), indexOptions);
                } else {
                    collection.ensureIndex(indexDefinition.getIndexKeys());
                }
                return null;
            }
        });
    }

    @Override
    public void dropIndex(final String name) {
        this.mongoOperations.execute(this.collectionName, new CollectionCallback<Void>(){

            @Override
            public Void doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                collection.dropIndex(name);
                return null;
            }
        });
    }

    @Override
    public void dropAllIndexes() {
        this.dropIndex("*");
    }

    @Override
    public void resetIndexCache() {
        this.mongoOperations.execute(this.collectionName, new CollectionCallback<Void>(){

            @Override
            public Void doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                collection.resetIndexCache();
                return null;
            }
        });
    }

    @Override
    public List<IndexInfo> getIndexInfo() {
        return this.mongoOperations.execute(this.collectionName, new CollectionCallback<List<IndexInfo>>(){

            @Override
            public List<IndexInfo> doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                List dbObjectList = collection.getIndexInfo();
                return this.getIndexData(dbObjectList);
            }

            private List<IndexInfo> getIndexData(List<DBObject> dbObjectList) {
                ArrayList<IndexInfo> indexInfoList = new ArrayList<IndexInfo>();
                for (DBObject ix : dbObjectList) {
                    LinkedHashMap<String, Order> keyOrderMap = new LinkedHashMap<String, Order>();
                    DBObject keyDbObject = (DBObject)ix.get("key");
                    for (Map.Entry thisEntry : keyDbObject.toMap().entrySet()) {
                        String key = thisEntry.getKey().toString();
                        int value = (Integer)thisEntry.getValue();
                        if (value == 1) {
                            keyOrderMap.put(key, Order.ASCENDING);
                            continue;
                        }
                        keyOrderMap.put(key, Order.DESCENDING);
                    }
                    String name = ix.get("name").toString();
                    boolean unique = ix.containsField("unique") ? (Boolean)ix.get("unique") : false;
                    boolean dropDuplicates = ix.containsField("dropDups") ? (Boolean)ix.get("dropDups") : false;
                    boolean sparse = ix.containsField("sparse") ? (Boolean)ix.get("sparse") : false;
                    indexInfoList.add(new IndexInfo(keyOrderMap, name, unique, dropDuplicates, sparse));
                }
                return indexInfoList;
            }
        });
    }
}

