/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.provider;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javax.persistence.Query;
import org.hibernate.Version;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public abstract class HibernateUtils {
    private static final List<String> TYPES = Arrays.asList("org.hibernate.jpa.HibernateQuery", "org.hibernate.ejb.HibernateQuery");
    private static final org.springframework.data.util.Version HIBERNATE4_VERSION_SUPPORTING_TUPLES = new org.springframework.data.util.Version(new int[]{4, 2, 21});
    private static final org.springframework.data.util.Version HIBERNATE5_VERSION = new org.springframework.data.util.Version(new int[]{5, 0, 0});
    private static final org.springframework.data.util.Version HIBERNATE5_VERSION_SUPPORTING_TUPLES = new org.springframework.data.util.Version(new int[]{5, 2, 11});
    private static final Method GET_HIBERNATE_QUERY;
    private static final Class<?> HIBERNATE_QUERY_INTERFACE;
    private static final Method QUERY_STRING_METHOD;
    private static final org.springframework.data.util.Version HIBERNATE_VERSION;

    private HibernateUtils() {
    }

    public static String getHibernateQuery(Object query) {
        if (HIBERNATE_QUERY_INTERFACE != null && QUERY_STRING_METHOD != null && HIBERNATE_QUERY_INTERFACE.isInstance(query)) {
            return (String)ReflectionUtils.invokeMethod((Method)QUERY_STRING_METHOD, (Object)query);
        }
        if (HIBERNATE_QUERY_INTERFACE != null && !HIBERNATE_QUERY_INTERFACE.isInstance(query)) {
            query = ((Query)query).unwrap(HIBERNATE_QUERY_INTERFACE);
        }
        return ((org.hibernate.Query)ReflectionUtils.invokeMethod((Method)GET_HIBERNATE_QUERY, (Object)query)).getQueryString();
    }

    public static boolean isVersionOrBetter(org.springframework.data.util.Version version) {
        return HIBERNATE_VERSION.isGreaterThanOrEqualTo(version);
    }

    public static boolean supportsTuples() {
        return HibernateUtils.isVersionInInterval(HIBERNATE4_VERSION_SUPPORTING_TUPLES, HIBERNATE5_VERSION) || HibernateUtils.isVersionOrBetter(HIBERNATE5_VERSION_SUPPORTING_TUPLES);
    }

    public static boolean supportsTuplesForNativeQueries() {
        return HibernateUtils.isVersionOrBetter(HIBERNATE5_VERSION_SUPPORTING_TUPLES);
    }

    private static boolean isVersionInInterval(org.springframework.data.util.Version lowerIncluding, org.springframework.data.util.Version upperExcluding) {
        return HIBERNATE_VERSION.isGreaterThanOrEqualTo(lowerIncluding) && HIBERNATE_VERSION.isLessThan(upperExcluding);
    }

    static {
        Class type = null;
        Method method = null;
        ClassLoader classLoader = HibernateUtils.class.getClassLoader();
        for (String typeName : TYPES) {
            try {
                type = ClassUtils.forName((String)typeName, (ClassLoader)classLoader);
                method = type.getMethod("getHibernateQuery", new Class[0]);
            }
            catch (Exception exception) {}
        }
        GET_HIBERNATE_QUERY = method;
        Class queryInterface = null;
        try {
            queryInterface = ClassUtils.forName((String)"org.hibernate.query.Query", (ClassLoader)classLoader);
        }
        catch (Exception typeName) {
            // empty catch block
        }
        HIBERNATE_QUERY_INTERFACE = queryInterface == null ? type : queryInterface;
        QUERY_STRING_METHOD = HIBERNATE_QUERY_INTERFACE == null ? null : ReflectionUtils.findMethod(HIBERNATE_QUERY_INTERFACE, (String)"getQueryString");
        String versionSource = Version.getVersionString();
        HIBERNATE_VERSION = org.springframework.data.util.Version.parse((String)versionSource.substring(0, versionSource.lastIndexOf(46)));
    }
}

