/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.persistence.AttributeNode;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.Subgraph;
import org.springframework.data.jpa.repository.query.JpaEntityGraph;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class Jpa21Utils {
    private static final Method GET_ENTITY_GRAPH_METHOD;
    private static final boolean JPA21_AVAILABLE;

    private Jpa21Utils() {
    }

    public static Map<String, Object> tryGetFetchGraphHints(EntityManager em, JpaEntityGraph entityGraph, Class<?> entityType) {
        if (entityGraph == null) {
            return Collections.emptyMap();
        }
        EntityGraph<?> graph = Jpa21Utils.tryGetFetchGraph(em, entityGraph, entityType);
        if (graph == null) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(entityGraph.getType().getKey(), graph);
    }

    private static EntityGraph<?> tryGetFetchGraph(EntityManager em, JpaEntityGraph jpaEntityGraph, Class<?> entityType) {
        Assert.notNull((Object)em, (String)"EntityManager must not be null!");
        Assert.notNull((Object)jpaEntityGraph, (String)"EntityGraph must not be null!");
        Assert.notNull(entityType, (String)"EntityType must not be null!");
        Assert.isTrue((boolean)JPA21_AVAILABLE, (String)"The EntityGraph-Feature requires at least a JPA 2.1 persistence provider!");
        Assert.isTrue((GET_ENTITY_GRAPH_METHOD != null ? 1 : 0) != 0, (String)"It seems that you have the JPA 2.1 API but a JPA 2.0 implementation on the classpath!");
        try {
            return em.getEntityGraph(jpaEntityGraph.getName());
        }
        catch (Exception ex) {
            return Jpa21Utils.createDynamicEntityGraph(em, jpaEntityGraph, entityType);
        }
    }

    private static EntityGraph<?> createDynamicEntityGraph(EntityManager em, JpaEntityGraph jpaEntityGraph, Class<?> entityType) {
        Assert.notNull((Object)em, (String)"EntityManager must not be null!");
        Assert.notNull((Object)jpaEntityGraph, (String)"JpaEntityGraph must not be null!");
        Assert.notNull(entityType, (String)"Entity type must not be null!");
        Assert.isTrue((boolean)jpaEntityGraph.isAdHocEntityGraph(), (String)("The given " + jpaEntityGraph + " is not dynamic!"));
        EntityGraph entityGraph = em.createEntityGraph(entityType);
        Jpa21Utils.configureFetchGraphFrom(jpaEntityGraph, entityGraph);
        return entityGraph;
    }

    static void configureFetchGraphFrom(JpaEntityGraph jpaEntityGraph, EntityGraph<?> entityGraph) {
        ArrayList<String> attributePaths = new ArrayList<String>(jpaEntityGraph.getAttributePaths());
        Collections.sort(attributePaths);
        Collections.reverse(attributePaths);
        for (String path : attributePaths) {
            if (!path.contains(".")) {
                if (Jpa21Utils.findAttributeNode(path, entityGraph) != null) continue;
                entityGraph.addAttributeNodes(new String[]{path});
                continue;
            }
            String[] pathComponents = StringUtils.delimitedListToStringArray((String)path, (String)".");
            Subgraph parent = null;
            for (int c = 0; c < pathComponents.length - 1; ++c) {
                parent = c == 0 ? Jpa21Utils.findOrCreateSubgraph(pathComponents[c], entityGraph) : parent.addSubgraph(pathComponents[c]);
            }
            parent.addAttributeNodes(new String[]{pathComponents[pathComponents.length - 1]});
        }
    }

    private static Subgraph<?> findOrCreateSubgraph(String name, EntityGraph<?> entityGraph) {
        Subgraph subgraph = Jpa21Utils.findSubgraph(name, entityGraph);
        return subgraph != null ? subgraph : entityGraph.addSubgraph(name);
    }

    private static Subgraph<?> findSubgraph(String name, EntityGraph<?> entityGraph) {
        AttributeNode<?> node = Jpa21Utils.findAttributeNode(name, entityGraph);
        if (node != null && !ObjectUtils.isEmpty((Object)node.getSubgraphs())) {
            return (Subgraph)node.getSubgraphs().values().iterator().next();
        }
        return null;
    }

    private static AttributeNode<?> findAttributeNode(String name, EntityGraph<?> entityGraph) {
        for (AttributeNode node : entityGraph.getAttributeNodes()) {
            if (!ObjectUtils.nullSafeEquals((Object)node.getAttributeName(), (Object)name)) continue;
            return node;
        }
        return null;
    }

    static {
        JPA21_AVAILABLE = ClassUtils.isPresent((String)"javax.persistence.NamedEntityGraph", (ClassLoader)Jpa21Utils.class.getClassLoader());
        GET_ENTITY_GRAPH_METHOD = JPA21_AVAILABLE ? ReflectionUtils.findMethod(EntityManager.class, (String)"getEntityGraph", (Class[])new Class[]{String.class}) : null;
    }
}

