/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import org.springframework.data.expression.ValueEvaluationContextProvider;
import org.springframework.data.expression.ValueExpression;
import org.springframework.data.expression.ValueExpressionParser;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethodValueEvaluationContextAccessor;
import org.springframework.expression.ParseException;

public class ValueExpressionDelegate
implements ValueExpressionParser {
    private final QueryMethodValueEvaluationContextAccessor contextAccessor;
    private final ValueExpressionParser valueExpressionParser;

    public ValueExpressionDelegate(QueryMethodValueEvaluationContextAccessor contextAccessor, ValueExpressionParser valueExpressionParser) {
        this.contextAccessor = contextAccessor;
        this.valueExpressionParser = valueExpressionParser;
    }

    ValueExpressionDelegate(ValueExpressionDelegate original) {
        this.contextAccessor = original.contextAccessor;
        this.valueExpressionParser = original.valueExpressionParser;
    }

    public static ValueExpressionDelegate create() {
        return new ValueExpressionDelegate(QueryMethodValueEvaluationContextAccessor.create(), ValueExpressionParser.create());
    }

    public ValueExpressionParser getValueExpressionParser() {
        return this.valueExpressionParser;
    }

    public QueryMethodValueEvaluationContextAccessor getEvaluationContextAccessor() {
        return this.contextAccessor;
    }

    public ValueEvaluationContextProvider createValueContextProvider(Parameters<?, ?> parameters) {
        return this.contextAccessor.create(parameters);
    }

    @Override
    public ValueExpression parse(String expressionString) throws ParseException {
        return this.valueExpressionParser.parse(expressionString);
    }
}

