/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javaslang.collection.Seq;
import javaslang.collection.Traversable;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Slice;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.repository.util.JavaslangCollections;
import org.springframework.data.repository.util.NullableWrapper;
import org.springframework.data.repository.util.ReactiveWrappers;
import org.springframework.data.repository.util.VavrCollections;
import org.springframework.data.util.StreamUtils;
import org.springframework.data.util.Streamable;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.concurrent.ListenableFuture;
import scala.Function0;
import scala.Option;
import scala.runtime.AbstractFunction0;

public abstract class QueryExecutionConverters {
    private static final boolean GUAVA_PRESENT = ClassUtils.isPresent((String)"com.google.common.base.Optional", (ClassLoader)QueryExecutionConverters.class.getClassLoader());
    private static final boolean JDK_8_PRESENT = ClassUtils.isPresent((String)"java.util.Optional", (ClassLoader)QueryExecutionConverters.class.getClassLoader());
    private static final boolean SCALA_PRESENT = ClassUtils.isPresent((String)"scala.Option", (ClassLoader)QueryExecutionConverters.class.getClassLoader());
    private static final boolean JAVASLANG_PRESENT = ClassUtils.isPresent((String)"javaslang.control.Option", (ClassLoader)QueryExecutionConverters.class.getClassLoader());
    private static final boolean VAVR_PRESENT = ClassUtils.isPresent((String)"io.vavr.control.Option", (ClassLoader)QueryExecutionConverters.class.getClassLoader());
    private static final Set<WrapperType> WRAPPER_TYPES = new HashSet<WrapperType>();
    private static final Set<WrapperType> UNWRAPPER_TYPES = new HashSet<WrapperType>();
    private static final Set<Converter<Object, Object>> UNWRAPPERS = new HashSet<Converter<Object, Object>>();
    private static final Set<Class<?>> ALLOWED_PAGEABLE_TYPES = new HashSet();

    private QueryExecutionConverters() {
    }

    public static boolean supports(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        for (WrapperType candidate : WRAPPER_TYPES) {
            if (!candidate.getType().isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean supportsUnwrapping(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        for (WrapperType candidate : UNWRAPPER_TYPES) {
            if (!candidate.getType().isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSingleValue(Class<?> type) {
        for (WrapperType candidate : WRAPPER_TYPES) {
            if (!candidate.getType().isAssignableFrom(type)) continue;
            return candidate.isSingleValue();
        }
        return false;
    }

    public static Set<Class<?>> getAllowedPageableTypes() {
        return Collections.unmodifiableSet(ALLOWED_PAGEABLE_TYPES);
    }

    public static void registerConvertersIn(ConfigurableConversionService conversionService) {
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null!");
        conversionService.removeConvertible(Collection.class, Object.class);
        if (GUAVA_PRESENT) {
            conversionService.addConverter((GenericConverter)new NullableWrapperToGuavaOptionalConverter((ConversionService)conversionService));
        }
        if (JDK_8_PRESENT) {
            conversionService.addConverter((GenericConverter)new NullableWrapperToJdk8OptionalConverter((ConversionService)conversionService));
            conversionService.addConverter((GenericConverter)new NullableWrapperToCompletableFutureConverter((ConversionService)conversionService));
        }
        if (SCALA_PRESENT) {
            conversionService.addConverter((GenericConverter)new NullableWrapperToScalaOptionConverter((ConversionService)conversionService));
        }
        if (JAVASLANG_PRESENT) {
            conversionService.addConverter((GenericConverter)new NullableWrapperToJavaslangOptionConverter((ConversionService)conversionService));
            conversionService.addConverter((GenericConverter)JavaslangCollections.FromJavaConverter.INSTANCE);
        }
        if (VAVR_PRESENT) {
            conversionService.addConverter((GenericConverter)new NullableWrapperToVavrOptionConverter((ConversionService)conversionService));
            conversionService.addConverter((GenericConverter)VavrCollections.FromJavaConverter.INSTANCE);
        }
        conversionService.addConverter((GenericConverter)new NullableWrapperToFutureConverter((ConversionService)conversionService));
        conversionService.addConverter((Converter)IterableToStreamableConverter.INSTANCE);
    }

    @Nullable
    public static Object unwrap(@Nullable Object source) {
        if (source == null || !QueryExecutionConverters.supports(source.getClass())) {
            return source;
        }
        for (Converter<Object, Object> converter : UNWRAPPERS) {
            Object result = converter.convert(source);
            if (result == source) continue;
            return result;
        }
        return source;
    }

    public static TypeInformation<?> unwrapWrapperTypes(TypeInformation<?> type) {
        Assert.notNull(type, (String)"type must not be null");
        Class<?> rawType = type.getType();
        boolean needToUnwrap = type.isCollectionLike() || Slice.class.isAssignableFrom(rawType) || GeoResults.class.isAssignableFrom(rawType) || rawType.isArray() || QueryExecutionConverters.supports(rawType) || Stream.class.isAssignableFrom(rawType);
        return needToUnwrap ? QueryExecutionConverters.unwrapWrapperTypes(type.getRequiredComponentType()) : type;
    }

    static {
        WRAPPER_TYPES.add(WrapperType.singleValue(Future.class));
        UNWRAPPER_TYPES.add(WrapperType.singleValue(Future.class));
        WRAPPER_TYPES.add(WrapperType.singleValue(ListenableFuture.class));
        UNWRAPPER_TYPES.add(WrapperType.singleValue(ListenableFuture.class));
        ALLOWED_PAGEABLE_TYPES.add(Slice.class);
        ALLOWED_PAGEABLE_TYPES.add(Page.class);
        ALLOWED_PAGEABLE_TYPES.add(List.class);
        if (GUAVA_PRESENT) {
            WRAPPER_TYPES.add(NullableWrapperToGuavaOptionalConverter.getWrapperType());
            UNWRAPPER_TYPES.add(NullableWrapperToGuavaOptionalConverter.getWrapperType());
            UNWRAPPERS.add(GuavaOptionalUnwrapper.INSTANCE);
        }
        if (JDK_8_PRESENT) {
            WRAPPER_TYPES.add(NullableWrapperToJdk8OptionalConverter.getWrapperType());
            UNWRAPPER_TYPES.add(NullableWrapperToJdk8OptionalConverter.getWrapperType());
            UNWRAPPERS.add(Jdk8OptionalUnwrapper.INSTANCE);
        }
        if (JDK_8_PRESENT) {
            WRAPPER_TYPES.add(NullableWrapperToCompletableFutureConverter.getWrapperType());
            UNWRAPPER_TYPES.add(NullableWrapperToCompletableFutureConverter.getWrapperType());
        }
        if (SCALA_PRESENT) {
            WRAPPER_TYPES.add(NullableWrapperToScalaOptionConverter.getWrapperType());
            UNWRAPPER_TYPES.add(NullableWrapperToScalaOptionConverter.getWrapperType());
            UNWRAPPERS.add(ScalOptionUnwrapper.INSTANCE);
        }
        if (JAVASLANG_PRESENT) {
            WRAPPER_TYPES.add(NullableWrapperToJavaslangOptionConverter.getWrapperType());
            WRAPPER_TYPES.add(JavaslangCollections.ToJavaConverter.INSTANCE.getWrapperType());
            UNWRAPPERS.add(JavaslangOptionUnwrapper.INSTANCE);
            ALLOWED_PAGEABLE_TYPES.add(Seq.class);
        }
        if (VAVR_PRESENT) {
            WRAPPER_TYPES.add(NullableWrapperToVavrOptionConverter.getWrapperType());
            WRAPPER_TYPES.add(VavrCollections.ToJavaConverter.INSTANCE.getWrapperType());
            UNWRAPPERS.add(VavrOptionUnwrapper.INSTANCE);
            ALLOWED_PAGEABLE_TYPES.add(io.vavr.collection.Seq.class);
        }
        if (ReactiveWrappers.isAvailable()) {
            WRAPPER_TYPES.addAll(ReactiveWrappers.getNoValueTypes().stream().map(WrapperType::noValue).collect(Collectors.toList()));
            WRAPPER_TYPES.addAll(ReactiveWrappers.getSingleValueTypes().stream().map(WrapperType::singleValue).collect(Collectors.toList()));
            WRAPPER_TYPES.addAll(ReactiveWrappers.getMultiValueTypes().stream().map(WrapperType::multiValue).collect(Collectors.toList()));
        }
    }

    public static final class WrapperType {
        private final Class<?> type;
        private final Cardinality cardinality;

        public static WrapperType singleValue(Class<?> type) {
            return new WrapperType(type, Cardinality.SINGLE);
        }

        public static WrapperType multiValue(Class<?> type) {
            return new WrapperType(type, Cardinality.MULTI);
        }

        public static WrapperType noValue(Class<?> type) {
            return new WrapperType(type, Cardinality.NONE);
        }

        boolean isSingleValue() {
            return this.cardinality.equals((Object)Cardinality.SINGLE);
        }

        public Class<?> getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WrapperType)) {
                return false;
            }
            WrapperType other = (WrapperType)o;
            Class<?> this$type = this.getType();
            Class<?> other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Cardinality this$cardinality = this.cardinality;
            Cardinality other$cardinality = other.cardinality;
            return !(this$cardinality == null ? other$cardinality != null : !((Object)((Object)this$cardinality)).equals((Object)other$cardinality));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Cardinality $cardinality = this.cardinality;
            result = result * 59 + ($cardinality == null ? 43 : ((Object)((Object)$cardinality)).hashCode());
            return result;
        }

        public String toString() {
            return "QueryExecutionConverters.WrapperType(type=" + this.getType() + ", cardinality=" + (Object)((Object)this.cardinality) + ")";
        }

        private WrapperType(Class<?> type, Cardinality cardinality) {
            this.type = type;
            this.cardinality = cardinality;
        }

        static enum Cardinality {
            NONE,
            SINGLE,
            MULTI;

        }
    }

    private static enum IterableToStreamableConverter implements Converter<Iterable<?>, Streamable<?>>
    {
        INSTANCE;


        @Nonnull
        public Streamable<?> convert(Iterable<?> source) {
            return Streamable.of(source);
        }
    }

    private static enum VavrOptionUnwrapper implements Converter<Object, Object>
    {
        INSTANCE;


        @Nullable
        public Object convert(Object source) {
            if (source instanceof io.vavr.control.Option) {
                return ((io.vavr.control.Option)source).getOrElse(() -> null);
            }
            if (source instanceof io.vavr.collection.Traversable) {
                return VavrCollections.ToJavaConverter.INSTANCE.convert(source);
            }
            return source;
        }
    }

    private static enum JavaslangOptionUnwrapper implements Converter<Object, Object>
    {
        INSTANCE;


        @Nullable
        public Object convert(Object source) {
            if (source instanceof javaslang.control.Option) {
                return ((javaslang.control.Option)source).getOrElse(() -> null);
            }
            if (source instanceof Traversable) {
                return JavaslangCollections.ToJavaConverter.INSTANCE.convert(source);
            }
            return source;
        }
    }

    private static enum ScalOptionUnwrapper implements Converter<Object, Object>
    {
        INSTANCE;

        private final Function0<Object> alternative = new AbstractFunction0<Object>(){

            @Nullable
            public Option<Object> apply() {
                return null;
            }
        };

        @Nullable
        public Object convert(Object source) {
            return source instanceof Option ? ((Option)source).getOrElse(this.alternative) : source;
        }
    }

    private static enum Jdk8OptionalUnwrapper implements Converter<Object, Object>
    {
        INSTANCE;


        @Nullable
        public Object convert(Object source) {
            return source instanceof Optional ? ((Optional)source).orElse(null) : source;
        }
    }

    private static enum GuavaOptionalUnwrapper implements Converter<Object, Object>
    {
        INSTANCE;


        @Nullable
        public Object convert(Object source) {
            return source instanceof com.google.common.base.Optional ? ((com.google.common.base.Optional)source).orNull() : source;
        }
    }

    private static class NullableWrapperToVavrOptionConverter
    extends AbstractWrapperTypeConverter {
        public NullableWrapperToVavrOptionConverter(ConversionService conversionService) {
            super(conversionService, io.vavr.control.Option.none(), Collections.singleton(io.vavr.control.Option.class));
        }

        public static WrapperType getWrapperType() {
            return WrapperType.singleValue(io.vavr.control.Option.class);
        }

        @Override
        protected Object wrap(Object source) {
            return io.vavr.control.Option.of((Object)source);
        }
    }

    private static class NullableWrapperToJavaslangOptionConverter
    extends AbstractWrapperTypeConverter {
        public NullableWrapperToJavaslangOptionConverter(ConversionService conversionService) {
            super(conversionService, javaslang.control.Option.none(), Collections.singleton(javaslang.control.Option.class));
        }

        public static WrapperType getWrapperType() {
            return WrapperType.singleValue(javaslang.control.Option.class);
        }

        @Override
        protected Object wrap(Object source) {
            return javaslang.control.Option.of((Object)source);
        }
    }

    private static class NullableWrapperToScalaOptionConverter
    extends AbstractWrapperTypeConverter {
        public NullableWrapperToScalaOptionConverter(ConversionService conversionService) {
            super(conversionService, Option.empty(), Collections.singleton(Option.class));
        }

        @Override
        protected Object wrap(Object source) {
            return Option.apply((Object)source);
        }

        public static WrapperType getWrapperType() {
            return WrapperType.singleValue(Option.class);
        }
    }

    private static class NullableWrapperToCompletableFutureConverter
    extends AbstractWrapperTypeConverter {
        public NullableWrapperToCompletableFutureConverter(ConversionService conversionService) {
            super(conversionService, CompletableFuture.completedFuture(null));
        }

        @Override
        protected Object wrap(Object source) {
            return source instanceof CompletableFuture ? source : CompletableFuture.completedFuture(source);
        }

        public static WrapperType getWrapperType() {
            return WrapperType.singleValue(CompletableFuture.class);
        }
    }

    private static class NullableWrapperToFutureConverter
    extends AbstractWrapperTypeConverter {
        public NullableWrapperToFutureConverter(ConversionService conversionService) {
            super(conversionService, new AsyncResult(null), Arrays.asList(Future.class, ListenableFuture.class));
        }

        @Override
        protected Object wrap(Object source) {
            return new AsyncResult(source);
        }
    }

    private static class NullableWrapperToJdk8OptionalConverter
    extends AbstractWrapperTypeConverter {
        public NullableWrapperToJdk8OptionalConverter(ConversionService conversionService) {
            super(conversionService, Optional.empty());
        }

        @Override
        protected Object wrap(Object source) {
            return Optional.of(source);
        }

        public static WrapperType getWrapperType() {
            return WrapperType.singleValue(Optional.class);
        }
    }

    private static class NullableWrapperToGuavaOptionalConverter
    extends AbstractWrapperTypeConverter {
        public NullableWrapperToGuavaOptionalConverter(ConversionService conversionService) {
            super(conversionService, com.google.common.base.Optional.absent(), Collections.singleton(com.google.common.base.Optional.class));
        }

        @Override
        protected Object wrap(Object source) {
            return com.google.common.base.Optional.of((Object)source);
        }

        public static WrapperType getWrapperType() {
            return WrapperType.singleValue(com.google.common.base.Optional.class);
        }
    }

    private static abstract class AbstractWrapperTypeConverter
    implements GenericConverter {
        @NonNull
        private final ConversionService conversionService;
        @NonNull
        private final Object nullValue;
        @NonNull
        private final Iterable<Class<?>> wrapperTypes;

        protected AbstractWrapperTypeConverter(ConversionService conversionService, Object nullValue) {
            Assert.notNull((Object)conversionService, (String)"ConversionService must not be null!");
            Assert.notNull((Object)nullValue, (String)"Null value must not be null!");
            this.conversionService = conversionService;
            this.nullValue = nullValue;
            this.wrapperTypes = Collections.singleton(nullValue.getClass());
        }

        @Nonnull
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Streamable.of(this.wrapperTypes).map(it -> new GenericConverter.ConvertiblePair(NullableWrapper.class, it)).stream().collect(StreamUtils.toUnmodifiableSet());
        }

        @Nullable
        public final Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (source == null) {
                return null;
            }
            NullableWrapper wrapper = (NullableWrapper)source;
            Object value = wrapper.getValue();
            return value == null ? this.nullValue : this.wrap(value);
        }

        protected abstract Object wrap(Object var1);

        public AbstractWrapperTypeConverter(@NonNull ConversionService conversionService, @NonNull Object nullValue, @NonNull Iterable<Class<?>> wrapperTypes) {
            if (conversionService == null) {
                throw new IllegalArgumentException("conversionService is null");
            }
            if (nullValue == null) {
                throw new IllegalArgumentException("nullValue is null");
            }
            if (wrapperTypes == null) {
                throw new IllegalArgumentException("wrapperTypes is null");
            }
            this.conversionService = conversionService;
            this.nullValue = nullValue;
            this.wrapperTypes = wrapperTypes;
        }
    }
}

