/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.data.repository.Repository;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class ClassUtils {
    private ClassUtils() {
    }

    public static boolean hasProperty(Class<?> type, String property) {
        if (null != ReflectionUtils.findMethod(type, (String)("get" + property))) {
            return true;
        }
        return null != ReflectionUtils.findField(type, (String)StringUtils.uncapitalize((String)property));
    }

    public static boolean isGenericRepositoryInterface(Class<?> interfaze) {
        return Repository.class.equals(interfaze);
    }

    public static boolean isGenericRepositoryInterface(String interfaceName) {
        return Repository.class.getName().equals(interfaceName);
    }

    public static int getNumberOfOccurences(Method method, Class<?> type) {
        int result = 0;
        for (Class<?> clazz : method.getParameterTypes()) {
            if (!type.equals(clazz)) continue;
            ++result;
        }
        return result;
    }

    public static void assertReturnTypeAssignable(Method method, Class<?> ... types) {
        for (Class<?> type : types) {
            if (!type.isAssignableFrom(method.getReturnType())) continue;
            return;
        }
        throw new IllegalStateException("Method has to have one of the following return types! " + Arrays.toString(types));
    }

    public static boolean isOfType(Object object, Collection<Class<?>> types) {
        if (null == object) {
            return false;
        }
        for (Class<?> type : types) {
            if (!type.isAssignableFrom(object.getClass())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasParameterOfType(Method method, Class<?> type) {
        return Arrays.asList(method.getParameterTypes()).contains(type);
    }

    public static void unwrapReflectionException(Exception ex) throws Throwable {
        if (ex instanceof InvocationTargetException) {
            throw ((InvocationTargetException)ex).getTargetException();
        }
        throw ex;
    }
}

