/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.init;

import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.io.Resource;
import org.springframework.data.repository.init.RepositoryPopulator;
import org.springframework.data.repository.init.ResourceReader;
import org.springframework.data.repository.init.ResourceReaderRepositoryPopulator;
import org.springframework.data.repository.support.Repositories;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRepositoryPopulatorFactoryBean
extends AbstractFactoryBean<ResourceReaderRepositoryPopulator>
implements ApplicationListener<ContextRefreshedEvent>,
ApplicationContextAware {
    private Resource[] resources;
    private RepositoryPopulator populator;
    private ApplicationContext context;

    public void setResources(Resource[] resources) {
        Assert.notNull((Object)resources, (String)"Resources must not be null!");
        this.resources = (Resource[])resources.clone();
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.context = applicationContext;
    }

    public Class<?> getObjectType() {
        return ResourceReaderRepositoryPopulator.class;
    }

    protected ResourceReaderRepositoryPopulator createInstance() throws Exception {
        ResourceReaderRepositoryPopulator initializer = new ResourceReaderRepositoryPopulator(this.getResourceReader());
        initializer.setResources(this.resources);
        initializer.setApplicationEventPublisher((ApplicationEventPublisher)this.context);
        this.populator = initializer;
        return initializer;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext().equals(this.context)) {
            Repositories repositories = new Repositories((ListableBeanFactory)event.getApplicationContext());
            this.populator.populate(repositories);
        }
    }

    protected abstract ResourceReader getResourceReader();
}

