/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.io.Serializable;
import org.springframework.data.repository.RepositoryDefinition;
import org.springframework.data.repository.core.support.AbstractRepositoryMetadata;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationRepositoryMetadata
extends AbstractRepositoryMetadata {
    private static final String NO_ANNOTATION_FOUND = String.format("Interface must be annotated with @%s!", RepositoryDefinition.class.getName());
    private final Class<?> repositoryInterface;

    public AnnotationRepositoryMetadata(Class<?> repositoryInterface) {
        super(repositoryInterface);
        Assert.isTrue((boolean)repositoryInterface.isAnnotationPresent(RepositoryDefinition.class), (String)NO_ANNOTATION_FOUND);
        this.repositoryInterface = repositoryInterface;
    }

    @Override
    public Class<? extends Serializable> getIdType() {
        RepositoryDefinition annotation = this.repositoryInterface.getAnnotation(RepositoryDefinition.class);
        return annotation == null ? null : annotation.idClass();
    }

    @Override
    public Class<?> getDomainType() {
        RepositoryDefinition annotation = this.repositoryInterface.getAnnotation(RepositoryDefinition.class);
        return annotation == null ? null : annotation.domainClass();
    }

    @Override
    public Class<?> getRepositoryInterface() {
        return this.repositoryInterface;
    }
}

