/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import java.util.HashMap;
import java.util.Map;
import org.springframework.data.convert.TypeInformationMapper;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingContextTypeInformationMapper
implements TypeInformationMapper {
    private final Map<TypeInformation<?>, Object> typeMap;
    private final MappingContext<? extends PersistentEntity<?, ?>, ?> mappingContext;

    public MappingContextTypeInformationMapper(MappingContext<? extends PersistentEntity<?, ?>, ?> mappingContext) {
        Assert.notNull(mappingContext);
        this.typeMap = new HashMap();
        this.mappingContext = mappingContext;
        for (PersistentEntity<?, ?> entity : mappingContext.getPersistentEntities()) {
            this.safelyAddToCache(entity.getTypeInformation(), entity.getTypeAlias());
        }
    }

    @Override
    public Object createAliasFor(TypeInformation<?> type) {
        Object key = this.typeMap.get(type);
        if (key != null) {
            return key;
        }
        PersistentEntity<?, ?> entity = this.mappingContext.getPersistentEntity(type);
        if (entity == null) {
            return null;
        }
        Object alias = entity.getTypeAlias();
        this.safelyAddToCache(type, alias);
        return alias;
    }

    private void safelyAddToCache(TypeInformation<?> key, Object alias) {
        if (alias == null) {
            return;
        }
        if (this.typeMap.containsValue(alias)) {
            throw new IllegalArgumentException(String.format("Detected mapping ambiguity! String %s cannot be mapped to more than one type!", alias));
        }
        this.typeMap.put(key, alias);
    }

    @Override
    public TypeInformation<?> resolveTypeFrom(Object alias) {
        if (alias == null) {
            return null;
        }
        for (Map.Entry<TypeInformation<?>, Object> entry : this.typeMap.entrySet()) {
            if (!entry.getValue().equals(alias)) continue;
            return entry.getKey();
        }
        for (PersistentEntity persistentEntity : this.mappingContext.getPersistentEntities()) {
            if (!alias.equals(persistentEntity.getTypeAlias())) continue;
            return persistentEntity.getTypeInformation();
        }
        return null;
    }
}

