/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.deployer;

import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.app.AppScaleRequest;
import org.springframework.cloud.deployer.spi.app.AppStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.core.RuntimeEnvironmentInfo;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.docs.AssertingSpan;
import org.springframework.cloud.sleuth.docs.AssertingSpanBuilder;
import org.springframework.cloud.sleuth.docs.DocumentedSpan;
import org.springframework.cloud.sleuth.docs.EventValue;
import org.springframework.cloud.sleuth.docs.TagKey;
import org.springframework.cloud.sleuth.instrument.deployer.SleuthDeployerSpan;
import org.springframework.cloud.sleuth.instrument.reactor.ReactorSleuth;
import org.springframework.core.env.Environment;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class TraceAppDeployer
implements AppDeployer {
    private static final Log log = LogFactory.getLog(TraceAppDeployer.class);
    private final AppDeployer delegate;
    private final BeanFactory beanFactory;
    private final Environment environment;
    private Tracer tracer;
    private CurrentTraceContext currentTraceContext;
    private Long pollDelay;

    public TraceAppDeployer(AppDeployer delegate, BeanFactory beanFactory, Environment environment) {
        this.delegate = delegate;
        this.beanFactory = beanFactory;
        this.environment = environment;
    }

    public String deploy(AppDeploymentRequest request) {
        AssertingSpanBuilder spanBuilder = this.clientSpan((DocumentedSpan)SleuthDeployerSpan.DEPLOYER_DEPLOY_SPAN, request);
        AssertingSpan span = spanBuilder.start();
        try (Tracer.SpanInScope spanInScope = this.tracer().withSpan((Span)span);){
            span.event((EventValue)SleuthDeployerSpan.Events.DEPLOYER_START);
            String id = this.delegate.deploy(request);
            span.tag((TagKey)SleuthDeployerSpan.Tags.APP_ID, id);
            this.registerListener((Span)span, id);
            String string = id;
            return string;
        }
    }

    private AssertingSpanBuilder clientSpan(DocumentedSpan documentedSpan) {
        return this.clientSpan(documentedSpan, null, null);
    }

    private AssertingSpanBuilder clientSpan(DocumentedSpan documentedSpan, @Nullable AppDeploymentRequest request) {
        return this.clientSpan(documentedSpan, null, request);
    }

    private AssertingSpanBuilder clientSpanKind(String name, AssertingSpanBuilder spanBuilder) {
        return spanBuilder.kind(Span.Kind.CLIENT).name(name).remoteServiceName(this.remoteServiceName());
    }

    private AssertingSpanBuilder clientSpan(DocumentedSpan documentedSpan, Span parentSpan) {
        return this.clientSpan(documentedSpan, parentSpan, null);
    }

    private AssertingSpanBuilder clientSpan(DocumentedSpan documentedSpan, @Nullable Span parentSpan, @Nullable AppDeploymentRequest request) {
        Span currentSpan;
        String name = documentedSpan.getName();
        AssertingSpanBuilder spanBuilder = AssertingSpanBuilder.of((DocumentedSpan)documentedSpan, (Span.Builder)this.tracer().spanBuilder());
        Span span = currentSpan = parentSpan != null ? parentSpan : this.tracer().currentSpan();
        if (currentSpan != null) {
            spanBuilder.setParent(currentSpan.context());
        }
        Map platformSpecificInfo = this.environmentInfo().getPlatformSpecificInfo();
        if (request != null) {
            String group;
            String appName;
            String platformName = (String)request.getDeploymentProperties().get("spring.cloud.deployer.platformName");
            if (StringUtils.hasText((String)platformName)) {
                spanBuilder.tag((TagKey)SleuthDeployerSpan.Tags.PLATFORM_NAME, platformName);
            }
            if (StringUtils.hasText((String)(appName = (String)request.getDeploymentProperties().get("spring.cloud.deployer.appName")))) {
                spanBuilder.tag((TagKey)SleuthDeployerSpan.Tags.APP_NAME, appName);
            }
            if (StringUtils.hasText((String)(group = (String)request.getDeploymentProperties().get("spring.cloud.deployer.group")))) {
                spanBuilder.tag((TagKey)SleuthDeployerSpan.Tags.APP_GROUP, group);
            }
        }
        this.addCfTags(spanBuilder, platformSpecificInfo);
        this.addK8sTags(spanBuilder, platformSpecificInfo);
        return this.clientSpanKind(name, spanBuilder);
    }

    private void addCfTags(AssertingSpanBuilder spanBuilder, Map<String, String> platformSpecificInfo) {
        if (platformSpecificInfo.containsKey("API Endpoint")) {
            spanBuilder.tag((TagKey)SleuthDeployerSpan.Tags.CF_URL, platformSpecificInfo.get("API Endpoint"));
        }
        if (platformSpecificInfo.containsKey("Organization")) {
            spanBuilder.tag((TagKey)SleuthDeployerSpan.Tags.CF_ORG, platformSpecificInfo.get("Organization"));
        }
        if (platformSpecificInfo.containsKey("Space")) {
            spanBuilder.tag((TagKey)SleuthDeployerSpan.Tags.CF_SPACE, platformSpecificInfo.get("Space"));
        }
    }

    private void addK8sTags(AssertingSpanBuilder spanBuilder, Map<String, String> platformSpecificInfo) {
        if (platformSpecificInfo.containsKey("master-url")) {
            spanBuilder.tag((TagKey)SleuthDeployerSpan.Tags.K8S_URL, platformSpecificInfo.get("master-url"));
        }
        if (platformSpecificInfo.containsKey("namespace")) {
            spanBuilder.tag((TagKey)SleuthDeployerSpan.Tags.K8S_NAMESPACE, platformSpecificInfo.get("namespace"));
        }
    }

    private String remoteServiceName() {
        return this.environmentInfo().getPlatformType();
    }

    private void registerListener(Span span, String id) {
        PreviousAndCurrentStatus previousAndCurrentStatus = new PreviousAndCurrentStatus(span);
        this.delegate.statusReactive(id).map(x$0 -> previousAndCurrentStatus.updateCurrent(x$0)).repeatWhen(repeat -> repeat.flatMap(i -> Mono.delay((Duration)Duration.ofMillis(this.pollDelay())))).takeUntil(rec$ -> ((PreviousAndCurrentStatus)rec$).isFinished()).last().doOnNext(rec$ -> ((PreviousAndCurrentStatus)rec$).annotateSpan()).doOnError(arg_0 -> ((Span)span).error(arg_0)).doFinally(signalType -> span.end()).subscribe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(String id) {
        AssertingSpanBuilder spanBuilder = this.clientSpan(SleuthDeployerSpan.DEPLOYER_UNDEPLOY_SPAN);
        AssertingSpan span = spanBuilder.start();
        span.tag((TagKey)SleuthDeployerSpan.Tags.APP_ID, id);
        try (Tracer.SpanInScope spanInScope = this.tracer().withSpan((Span)span);){
            span.event((EventValue)SleuthDeployerSpan.Events.DEPLOYER_START);
            this.delegate.undeploy(id);
            this.registerListener((Span)span, id);
        }
        finally {
            span.end();
        }
    }

    public AppStatus status(String id) {
        AssertingSpanBuilder spanBuilder = this.clientSpan(SleuthDeployerSpan.DEPLOYER_STATUS_SPAN);
        AssertingSpan span = spanBuilder.start();
        span.tag((TagKey)SleuthDeployerSpan.Tags.APP_ID, id);
        try {
            AppStatus appStatus;
            block9: {
                Tracer.SpanInScope spanInScope = this.tracer().withSpan((Span)span.start());
                try {
                    appStatus = this.delegate.status(id);
                    if (spanInScope == null) break block9;
                }
                catch (Throwable throwable) {
                    if (spanInScope != null) {
                        try {
                            spanInScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                spanInScope.close();
            }
            return appStatus;
        }
        finally {
            span.end();
        }
    }

    public Mono<AppStatus> statusReactive(String id) {
        return ReactorSleuth.tracedMono(this.tracer(), this.currentTraceContext(), SleuthDeployerSpan.DEPLOYER_STATUS_SPAN.getName(), () -> this.delegate.statusReactive(id), (o, span) -> span.tag(SleuthDeployerSpan.Tags.APP_ID.getKey(), id), span -> this.clientSpan((DocumentedSpan)SleuthDeployerSpan.DEPLOYER_STATUS_SPAN, (Span)span).start());
    }

    public Flux<AppStatus> statusesReactive(String ... ids) {
        return ReactorSleuth.tracedFlux(this.tracer(), this.currentTraceContext(), SleuthDeployerSpan.DEPLOYER_STATUSES_SPAN.getName(), () -> this.delegate.statusesReactive(ids), (o, span) -> span.tag(SleuthDeployerSpan.Tags.APP_ID.getKey(), Arrays.toString(ids)), span -> this.clientSpan((DocumentedSpan)SleuthDeployerSpan.DEPLOYER_STATUSES_SPAN, (Span)span).start());
    }

    public RuntimeEnvironmentInfo environmentInfo() {
        return this.delegate.environmentInfo();
    }

    public String getLog(String id) {
        AssertingSpanBuilder spanBuilder = this.clientSpan(SleuthDeployerSpan.DEPLOYER_GET_LOG_SPAN);
        AssertingSpan span = spanBuilder.start();
        span.tag((TagKey)SleuthDeployerSpan.Tags.APP_ID, id);
        try {
            String string;
            block9: {
                Tracer.SpanInScope spanInScope = this.tracer().withSpan((Span)span);
                try {
                    string = this.delegate.getLog(id);
                    if (spanInScope == null) break block9;
                }
                catch (Throwable throwable) {
                    if (spanInScope != null) {
                        try {
                            spanInScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                spanInScope.close();
            }
            return string;
        }
        finally {
            span.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scale(AppScaleRequest appScaleRequest) {
        AssertingSpanBuilder spanBuilder = this.clientSpan(SleuthDeployerSpan.DEPLOYER_SCALE_SPAN);
        AssertingSpan span = spanBuilder.start();
        span.tag((TagKey)SleuthDeployerSpan.ScaleTags.DEPLOYER_SCALE_DEPLOYMENT_ID, appScaleRequest.getDeploymentId());
        span.tag((TagKey)SleuthDeployerSpan.ScaleTags.DEPLOYER_SCALE_COUNT, String.valueOf(appScaleRequest.getCount()));
        try (Tracer.SpanInScope spanInScope = this.tracer().withSpan((Span)span.start());){
            this.delegate.scale(appScaleRequest);
        }
        finally {
            span.end();
        }
    }

    private Tracer tracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
        }
        return this.tracer;
    }

    private CurrentTraceContext currentTraceContext() {
        if (this.currentTraceContext == null) {
            this.currentTraceContext = (CurrentTraceContext)this.beanFactory.getBean(CurrentTraceContext.class);
        }
        return this.currentTraceContext;
    }

    private long pollDelay() {
        if (this.pollDelay == null) {
            this.pollDelay = (Long)this.environment.getProperty("spring.sleuth.deployer.status-poll-delay", Long.class, (Object)500L);
        }
        return this.pollDelay;
    }

    private static final class PreviousAndCurrentStatus {
        private final Span span;
        private AppStatus current;
        private AppStatus previous;

        private PreviousAndCurrentStatus(Span span) {
            this.span = span;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Current span is [" + span + "]"));
            }
        }

        private PreviousAndCurrentStatus updateCurrent(AppStatus current) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("State before change: current [" + this.current + "], previous [" + this.previous + "]"));
            }
            this.previous = this.current;
            this.current = current;
            if (log.isTraceEnabled()) {
                log.trace((Object)("State after change: current [" + this.current + "], previous [" + this.previous + "]"));
            }
            if (this.statusChanged()) {
                this.annotateSpan();
            } else if (log.isTraceEnabled()) {
                log.trace((Object)"State has not changed, will not annotate the span");
            }
            return this;
        }

        private void annotateSpan() {
            String name = this.current.getState().name();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will annotate its state with [" + name + "]"));
            }
            this.span.event(String.format(SleuthDeployerSpan.Events.DEPLOYER_STATUS_CHANGE.getValue(), name));
        }

        private boolean statusChanged() {
            DeploymentState previousState;
            if (this.previous == null && this.current != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Previous is null, current is not null");
                }
                return true;
            }
            if (this.current == null) {
                throw new IllegalStateException("Current state can't be null");
            }
            DeploymentState currentState = this.current.getState();
            return currentState != (previousState = this.previous.getState());
        }

        private boolean isFinished() {
            boolean finished;
            boolean bl = finished = this.current.getState() == DeploymentState.deployed || this.current.getState() == DeploymentState.undeployed || this.current.getState() == DeploymentState.failed || this.current.getState() == DeploymentState.error || this.current.getState() == DeploymentState.unknown;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Status is finished [" + finished + "]"));
            }
            return finished;
        }
    }
}

