/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import java.util.Objects;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import org.springframework.cloud.sleuth.instrument.reactor.TraceContextPropagator;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoOperator;
import reactor.core.publisher.Operators;

final class SleuthMonoLift<I, O>
extends MonoOperator<I, O>
implements TraceContextPropagator {
    final BiFunction<Publisher, ? super CoreSubscriber<? super O>, ? extends CoreSubscriber<? super I>> lifter;

    SleuthMonoLift(Publisher<I> p, BiFunction<Publisher, ? super CoreSubscriber<? super O>, ? extends CoreSubscriber<? super I>> lifter) {
        super(Mono.from(p));
        this.lifter = lifter;
    }

    public void subscribe(CoreSubscriber<? super O> actual) {
        CoreSubscriber<? super O> input = actual;
        try {
            input = Objects.requireNonNull(this.lifter.apply((Publisher)this.source, actual), "Lifted subscriber MUST NOT be null");
            this.source.subscribe(input);
        }
        catch (Throwable e) {
            Operators.reportThrowInSubscribe(input, (Throwable)e);
            return;
        }
    }

    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }
}

