/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.docs;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.cloud.sleuth.docs.AssertingSpan;
import org.springframework.cloud.sleuth.docs.DocumentedSpan;
import org.springframework.cloud.sleuth.docs.EventValue;
import org.springframework.cloud.sleuth.docs.TagKey;
import org.springframework.util.StringUtils;

final class DocumentedSpanAssertions {
    static boolean SLEUTH_SPAN_ASSERTIONS_ON = Boolean.parseBoolean(System.getProperty("spring.cloud.sleuth.assertions.enabled", System.getenv("SPRING_CLOUD_SLEUTH_ASSERTIONS_ENABLED") != null ? System.getenv("SPRING_CLOUD_SLEUTH_ASSERTIONS_ENABLED") : "false"));
    private static final Map<String, Pattern> PATTERN_CACHE = new ConcurrentHashMap<String, Pattern>();
    private static final Pattern SPECIAL_REGEX_CHARS = Pattern.compile("[{}()\\[\\].+*?^$\\\\|]");

    private DocumentedSpanAssertions() {
        throw new IllegalStateException("Can't instantiate utility class");
    }

    static void assertThatKeyIsValid(String key, DocumentedSpan documentedSpan) {
        if (SLEUTH_SPAN_ASSERTIONS_ON) {
            TagKey[] allowedKeys = documentedSpan.getTagKeys();
            if (allowedKeys.length == 0) {
                return;
            }
            boolean validTagKey = Arrays.stream(allowedKeys).anyMatch(tagKey -> DocumentedSpanAssertions.patternOrValueMatches(key, tagKey.getKey()) && DocumentedSpanAssertions.hasRequiredPrefix(key, documentedSpan.prefix()));
            if (!validTagKey) {
                throw new AssertionError((Object)("The key [" + key + "] is invalid. You can use only one matching " + Arrays.stream(allowedKeys).map(TagKey::getKey).collect(Collectors.toList()) + DocumentedSpanAssertions.prefixWarningIfPresent(documentedSpan)));
            }
        }
    }

    private static String prefixWarningIfPresent(DocumentedSpan documentedSpan) {
        return StringUtils.hasText((String)documentedSpan.prefix()) ? ". Also it has start with [" + documentedSpan.prefix() + "] prefix" : "";
    }

    static void assertThatKeyIsValid(TagKey key, DocumentedSpan documentedSpan) {
        if (SLEUTH_SPAN_ASSERTIONS_ON) {
            TagKey[] allowedKeys = documentedSpan.getTagKeys();
            if (allowedKeys.length == 0) {
                return;
            }
            if (Arrays.stream(allowedKeys).noneMatch(tagKey -> DocumentedSpanAssertions.patternOrValueMatches(key.getKey(), tagKey.getKey()) && DocumentedSpanAssertions.hasRequiredPrefix(key.getKey(), documentedSpan.prefix()))) {
                throw new AssertionError((Object)("The key [" + key.getKey() + "] is invalid. You can use only one matching " + Arrays.stream(allowedKeys).map(TagKey::getKey).collect(Collectors.toList()) + DocumentedSpanAssertions.prefixWarningIfPresent(documentedSpan)));
            }
        }
    }

    static void assertThatNameIsValid(String name, DocumentedSpan documentedSpan) {
        String allowedName = documentedSpan.getName();
        if (SLEUTH_SPAN_ASSERTIONS_ON && !DocumentedSpanAssertions.patternOrValueMatches(name, allowedName)) {
            throw new AssertionError((Object)("The name [" + name + "] is invalid. You can use only one matching [" + allowedName + "]"));
        }
    }

    static void assertThatEventIsValid(String eventValue, DocumentedSpan documentedSpan) {
        if (SLEUTH_SPAN_ASSERTIONS_ON) {
            EventValue[] allowed = documentedSpan.getEvents();
            if (allowed.length == 0) {
                return;
            }
            boolean valid = Arrays.stream(allowed).anyMatch(value -> DocumentedSpanAssertions.patternOrValueMatches(eventValue, value.getValue()) && DocumentedSpanAssertions.hasRequiredPrefix(eventValue, documentedSpan.prefix()));
            if (!valid) {
                throw new AssertionError((Object)("The event [" + eventValue + "] is invalid. You can use only one matching " + Arrays.stream(allowed).map(EventValue::getValue).collect(Collectors.toList()) + DocumentedSpanAssertions.prefixWarningIfPresent(documentedSpan)));
            }
        }
    }

    static void assertThatEventIsValid(EventValue eventValue, DocumentedSpan documentedSpan) {
        if (SLEUTH_SPAN_ASSERTIONS_ON) {
            EventValue[] allowed = documentedSpan.getEvents();
            if (allowed.length == 0) {
                return;
            }
            if (Arrays.stream(allowed).noneMatch(value -> DocumentedSpanAssertions.patternOrValueMatches(eventValue.getValue(), value.getValue()) && DocumentedSpanAssertions.hasRequiredPrefix(eventValue.getValue(), documentedSpan.prefix()))) {
                throw new AssertionError((Object)("The event [" + eventValue.getValue() + "] is invalid. You can use only one matching " + Arrays.stream(allowed).map(EventValue::getValue).collect(Collectors.toList()) + DocumentedSpanAssertions.prefixWarningIfPresent(documentedSpan)));
            }
        }
    }

    static void assertThatSpanStartedBeforeEnd(AssertingSpan span) {
        if (SLEUTH_SPAN_ASSERTIONS_ON && !span.isStarted()) {
            throw new AssertionError((Object)"The span was not started, however you're trying to end it");
        }
    }

    private static boolean patternOrValueMatches(String pickedValue, String allowedValue) {
        if (allowedValue.contains("%s")) {
            String stringPattern = DocumentedSpanAssertions.escapeSpecialRegexWithSingleEscape(allowedValue).replaceAll("%s", ".*?");
            Pattern pattern = PATTERN_CACHE.computeIfAbsent(stringPattern, Pattern::compile);
            return pattern.matcher(pickedValue).matches();
        }
        return allowedValue.equals(pickedValue);
    }

    private static boolean hasRequiredPrefix(String value, String prefix) {
        if (StringUtils.hasText((String)prefix)) {
            return value.startsWith(prefix);
        }
        return true;
    }

    private static String escapeSpecialRegexWithSingleEscape(String str) {
        return SPECIAL_REGEX_CHARS.matcher(str).replaceAll("\\\\$0");
    }
}

