/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.http;

import java.util.Arrays;
import java.util.Map;
import org.springframework.cloud.contract.verifier.util.MetadataUtil;
import org.springframework.cloud.contract.verifier.util.SpringCloudContractMetadata;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class ContractVerifierHttpMetaData
implements SpringCloudContractMetadata {
    public static final String METADATA_KEY = "verifierHttp";
    private Scheme scheme = Scheme.HTTP;
    private Protocol protocol = Protocol.HTTP_1_1;

    @NonNull
    public static ContractVerifierHttpMetaData fromMetadata(Map<String, Object> metadata) {
        return MetadataUtil.fromMetadata(metadata, METADATA_KEY, new ContractVerifierHttpMetaData());
    }

    @Override
    public String key() {
        return METADATA_KEY;
    }

    @Override
    public String description() {
        return "Metadata entries used by the framework";
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    public void setScheme(Scheme scheme) {
        this.scheme = scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = Scheme.fromString(scheme);
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = Protocol.fromString(protocol);
    }

    public static enum Scheme {
        HTTP,
        HTTPS;


        @Nullable
        public static Scheme fromString(String scheme) {
            return Arrays.stream(Scheme.values()).filter(p -> p.name().equalsIgnoreCase(scheme)).findFirst().orElse(null);
        }
    }

    public static enum Protocol {
        HTTP_1_0("http/1.0"),
        HTTP_1_1("http/1.1"),
        HTTP_2("h2"),
        H2_PRIOR_KNOWLEDGE("h2_prior_knowledge"),
        QUIC("quic");

        private final String protocol;

        private Protocol(String protocol) {
            this.protocol = protocol;
        }

        public String toString() {
            return this.protocol;
        }

        @Nullable
        public static Protocol fromString(String protocol) {
            return Arrays.stream(Protocol.values()).filter(p -> p.protocol.equalsIgnoreCase(protocol)).findFirst().orElse(null);
        }
    }
}

