/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.diagnostics;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.SpringBootExceptionReporter;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.boot.diagnostics.FailureAnalysisReporter;
import org.springframework.boot.diagnostics.FailureAnalyzer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.log.LogMessage;

final class FailureAnalyzers
implements SpringBootExceptionReporter {
    private static final Log logger = LogFactory.getLog(FailureAnalyzers.class);
    private final SpringFactoriesLoader springFactoriesLoader;
    private final List<FailureAnalyzer> analyzers;

    public FailureAnalyzers(@Nullable ConfigurableApplicationContext context) {
        this(context, SpringFactoriesLoader.forDefaultResourceLocation((ClassLoader)(context != null ? context.getClassLoader() : null)));
    }

    FailureAnalyzers(@Nullable ConfigurableApplicationContext context, SpringFactoriesLoader springFactoriesLoader) {
        this.springFactoriesLoader = springFactoriesLoader;
        this.analyzers = FailureAnalyzers.loadFailureAnalyzers(context, this.springFactoriesLoader);
    }

    private static List<FailureAnalyzer> loadFailureAnalyzers(@Nullable ConfigurableApplicationContext context, SpringFactoriesLoader springFactoriesLoader) {
        return springFactoriesLoader.load(FailureAnalyzer.class, FailureAnalyzers.getArgumentResolver(context), SpringFactoriesLoader.FailureHandler.logging((Log)logger));
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable SpringFactoriesLoader.ArgumentResolver getArgumentResolver(@Nullable ConfigurableApplicationContext context) {
        if (context == null) {
            return null;
        }
        SpringFactoriesLoader.ArgumentResolver argumentResolver = SpringFactoriesLoader.ArgumentResolver.of(BeanFactory.class, (Object)context.getBeanFactory());
        argumentResolver = argumentResolver.and(Environment.class, (Object)context.getEnvironment());
        return argumentResolver;
    }

    @Override
    public boolean reportException(Throwable failure) {
        FailureAnalysis analysis = this.analyze(failure, this.analyzers);
        return this.report(analysis);
    }

    private @Nullable FailureAnalysis analyze(Throwable failure, List<FailureAnalyzer> analyzers) {
        for (FailureAnalyzer analyzer : analyzers) {
            try {
                FailureAnalysis analysis = analyzer.analyze(failure);
                if (analysis == null) continue;
                return analysis;
            }
            catch (Throwable ex) {
                logger.trace((Object)LogMessage.format((String)"FailureAnalyzer %s failed", (Object)analyzer), ex);
            }
        }
        return null;
    }

    private boolean report(@Nullable FailureAnalysis analysis) {
        List reporters = this.springFactoriesLoader.load(FailureAnalysisReporter.class);
        if (analysis == null || reporters.isEmpty()) {
            return false;
        }
        for (FailureAnalysisReporter reporter : reporters) {
            reporter.report(analysis);
        }
        return true;
    }
}

