/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.restclient;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.restclient.BasicAuthentication;
import org.springframework.boot.restclient.RestTemplateRequestCustomizer;
import org.springframework.boot.util.LambdaSafe;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestInitializer;

class RestTemplateBuilderClientHttpRequestInitializer
implements ClientHttpRequestInitializer {
    private final @Nullable BasicAuthentication basicAuthentication;
    private final Map<String, List<String>> defaultHeaders;
    private final Set<RestTemplateRequestCustomizer<?>> requestCustomizers;

    RestTemplateBuilderClientHttpRequestInitializer(@Nullable BasicAuthentication basicAuthentication, Map<String, List<String>> defaultHeaders, Set<RestTemplateRequestCustomizer<?>> requestCustomizers) {
        this.basicAuthentication = basicAuthentication;
        this.defaultHeaders = defaultHeaders;
        this.requestCustomizers = requestCustomizers;
    }

    public void initialize(ClientHttpRequest request) {
        HttpHeaders headers = request.getHeaders();
        if (this.basicAuthentication != null) {
            this.basicAuthentication.applyTo(headers);
        }
        this.defaultHeaders.forEach((arg_0, arg_1) -> ((HttpHeaders)headers).putIfAbsent(arg_0, arg_1));
        LambdaSafe.callbacks(RestTemplateRequestCustomizer.class, this.requestCustomizers, (Object)request, (Object[])new Object[0]).invoke(customizer -> customizer.customize(request));
    }
}

