/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.data;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.actuate.metrics.AutoTimer;
import org.springframework.boot.actuate.metrics.annotation.TimedAnnotations;
import org.springframework.boot.actuate.metrics.data.RepositoryTagsProvider;
import org.springframework.data.repository.core.support.RepositoryMethodInvocationListener;

public class MetricsRepositoryMethodInvocationListener
implements RepositoryMethodInvocationListener {
    private final MeterRegistry registry;
    private final RepositoryTagsProvider tagsProvider;
    private final String metricName;
    private final AutoTimer autoTimer;

    public MetricsRepositoryMethodInvocationListener(MeterRegistry registry, RepositoryTagsProvider tagsProvider, String metricName, AutoTimer autoTimer) {
        this.registry = registry;
        this.tagsProvider = tagsProvider;
        this.metricName = metricName;
        this.autoTimer = autoTimer != null ? autoTimer : AutoTimer.DISABLED;
    }

    public void afterInvocation(RepositoryMethodInvocationListener.RepositoryMethodInvocation invocation) {
        Set<Timed> annotations = TimedAnnotations.get(invocation.getMethod(), invocation.getRepositoryInterface());
        Iterable<Tag> tags = this.tagsProvider.repositoryTags(invocation);
        long duration = invocation.getDuration(TimeUnit.NANOSECONDS);
        AutoTimer.apply(this.autoTimer, this.metricName, annotations, builder -> builder.tags(tags).register(this.registry).record(duration, TimeUnit.NANOSECONDS));
    }
}

