/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public final class MicrometerHolder {
    private final ConcurrentMap<String, Timer> timers = new ConcurrentHashMap<String, Timer>();
    private final MeterRegistry registry;
    private final Map<String, String> tags;
    private final String listenerId;

    MicrometerHolder(@Nullable ApplicationContext context, String listenerId, Map<String, String> tags) {
        Assert.notNull((Object)context, (String)"'context' must not be null");
        try {
            this.registry = (MeterRegistry)context.getBeanProvider(MeterRegistry.class).getIfUnique();
        }
        catch (NoUniqueBeanDefinitionException ex) {
            throw new IllegalStateException(ex);
        }
        if (this.registry == null) {
            throw new IllegalStateException("No micrometer registry present (or more than one and there is not exactly one marked with @Primary)");
        }
        this.listenerId = listenerId;
        this.tags = tags;
    }

    public Object start() {
        return Timer.start((MeterRegistry)this.registry);
    }

    public void success(Object sample, String queue) {
        Timer timer = (Timer)this.timers.get(queue + "none");
        if (timer == null) {
            timer = this.buildTimer(this.listenerId, "success", queue, "none");
        }
        ((Timer.Sample)sample).stop(timer);
    }

    public void failure(Object sample, String queue, String exception) {
        Timer timer = (Timer)this.timers.get(queue + exception);
        if (timer == null) {
            timer = this.buildTimer(this.listenerId, "failure", queue, exception);
        }
        ((Timer.Sample)sample).stop(timer);
    }

    private Timer buildTimer(String aListenerId, String result, String queue, String exception) {
        Timer.Builder builder = Timer.builder((String)"spring.rabbitmq.listener").description("Spring RabbitMQ Listener").tag("listener.id", aListenerId).tag("queue", queue).tag("result", result).tag("exception", exception);
        if (!CollectionUtils.isEmpty(this.tags)) {
            this.tags.forEach((arg_0, arg_1) -> ((Timer.Builder)builder).tag(arg_0, arg_1));
        }
        Timer registeredTimer = builder.register(this.registry);
        this.timers.put(queue + exception, registeredTimer);
        return registeredTimer;
    }

    void destroy() {
        this.timers.values().forEach(arg_0 -> ((MeterRegistry)this.registry).remove(arg_0));
        this.timers.clear();
    }
}

