/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.providers;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Json31;
import io.swagger.v3.core.util.ObjectMapperFactory;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.core.util.Yaml31;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import org.springdoc.api.mixins.SortedOpenAPIMixin;
import org.springdoc.api.mixins.SortedOpenAPIMixin31;
import org.springdoc.api.mixins.SortedSchemaMixin;
import org.springdoc.api.mixins.SortedSchemaMixin31;
import org.springdoc.core.SpringDocConfigProperties;

public class ObjectMapperProvider
extends ObjectMapperFactory {
    private final ObjectMapper jsonMapper;
    private final ObjectMapper yamlMapper;

    public ObjectMapperProvider(SpringDocConfigProperties springDocConfigProperties) {
        SpringDocConfigProperties.ApiDocs.OpenApiVersion openApiVersion = springDocConfigProperties.getApiDocs().getVersion();
        if (openApiVersion == SpringDocConfigProperties.ApiDocs.OpenApiVersion.OPENAPI_3_1) {
            this.jsonMapper = Json31.mapper();
            this.yamlMapper = Yaml31.mapper();
        } else {
            this.jsonMapper = Json.mapper();
            this.yamlMapper = Yaml.mapper();
        }
    }

    public static ObjectMapper createJson(SpringDocConfigProperties springDocConfigProperties) {
        SpringDocConfigProperties.ApiDocs.OpenApiVersion openApiVersion = springDocConfigProperties.getApiDocs().getVersion();
        ObjectMapper objectMapper = openApiVersion == SpringDocConfigProperties.ApiDocs.OpenApiVersion.OPENAPI_3_1 ? ObjectMapperFactory.createJson31() : ObjectMapperFactory.createJson();
        if (springDocConfigProperties.isWriterWithOrderByKeys()) {
            ObjectMapperProvider.sortOutput(objectMapper, springDocConfigProperties);
        }
        return objectMapper;
    }

    public static void sortOutput(ObjectMapper objectMapper, SpringDocConfigProperties springDocConfigProperties) {
        objectMapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        objectMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        if (SpringDocConfigProperties.ApiDocs.OpenApiVersion.OPENAPI_3_1 == springDocConfigProperties.getApiDocs().getVersion()) {
            objectMapper.addMixIn(OpenAPI.class, SortedOpenAPIMixin31.class);
            objectMapper.addMixIn(Schema.class, SortedSchemaMixin31.class);
        } else {
            objectMapper.addMixIn(OpenAPI.class, SortedOpenAPIMixin.class);
            objectMapper.addMixIn(Schema.class, SortedSchemaMixin.class);
        }
    }

    public ObjectMapper jsonMapper() {
        return this.jsonMapper;
    }

    public ObjectMapper yamlMapper() {
        return this.yamlMapper;
    }
}

