/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.util.Locale;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.config.Settings;
import org.sonar.api.i18n.I18n;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.Duration;

@ScannerSide
@ServerSide
@ComputeEngineSide
public class Durations {
    private final Settings settings;
    private final I18n i18n;

    public Durations(Settings settings, I18n i18n) {
        this.settings = settings;
        this.i18n = i18n;
    }

    public Duration create(long minutes) {
        return Duration.create(minutes);
    }

    public Duration decode(String duration) {
        return Duration.decode(duration, this.hoursInDay());
    }

    public String encode(Duration duration) {
        return duration.encode(this.hoursInDay());
    }

    public String format(Locale locale, Duration duration, DurationFormat format) {
        return this.format(locale, duration);
    }

    public String format(Locale locale, Duration duration) {
        Long durationInMinutes = duration.toMinutes();
        if (durationInMinutes == 0L) {
            return "0";
        }
        boolean isNegative = durationInMinutes < 0L;
        Long absDuration = Math.abs(durationInMinutes);
        int days = Double.valueOf((double)absDuration.longValue() / (double)this.hoursInDay() / 60.0).intValue();
        Long remainingDuration = absDuration - (long)(days * this.hoursInDay() * 60);
        int hours = Double.valueOf(remainingDuration.doubleValue() / 60.0).intValue();
        remainingDuration = remainingDuration - (long)(hours * 60);
        int minutes = remainingDuration.intValue();
        return this.format(locale, days, hours, minutes, isNegative);
    }

    private String format(Locale locale, int days, int hours, int minutes, boolean isNegative) {
        StringBuilder message = new StringBuilder();
        if (days > 0) {
            message.append(this.message(locale, "work_duration.x_days", isNegative ? -1 * days : days));
        }
        if (Durations.displayHours(days, hours)) {
            Durations.addSpaceIfNeeded(message);
            message.append(this.message(locale, "work_duration.x_hours", isNegative && message.length() == 0 ? -1 * hours : hours));
        }
        if (Durations.displayMinutes(days, hours, minutes)) {
            Durations.addSpaceIfNeeded(message);
            message.append(this.message(locale, "work_duration.x_minutes", isNegative && message.length() == 0 ? -1 * minutes : minutes));
        }
        return message.toString();
    }

    private String message(Locale locale, String key, @CheckForNull Object parameter) {
        return this.i18n.message(locale, key, null, parameter);
    }

    private static boolean displayHours(int days, int hours) {
        return hours > 0 && days < 10;
    }

    private static boolean displayMinutes(int days, int hours, int minutes) {
        return minutes > 0 && hours < 10 && days == 0;
    }

    private static void addSpaceIfNeeded(StringBuilder message) {
        if (message.length() > 0) {
            message.append(" ");
        }
    }

    private int hoursInDay() {
        return this.settings.getInt("sonar.technicalDebt.hoursInDay");
    }

    public static enum DurationFormat {
        SHORT;

    }
}

