package org.sharengo.wikitty.generator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.ObjectModelGenerator;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.util.Resource;

public class WikittyMetaGenerator extends ObjectModelGenerator {

    protected static Log log = LogFactory.getLog(WikittyMetaGenerator.class);

    /**
     * la liste des generateurs par defaut a utiliser
     */
    protected static final List<Class<? extends WikengoCommonGenerator>> DEFAULT_GENERATORS =
            Collections.unmodifiableList(Arrays.asList(

            // Enum
            InterfaceGenerator.class,
            EnumGenerator.class,

            // Wikitty (Interface, impl...)
            BusinessEntityInterfaceGenerator.class,
            BusinessEntityGenerator.class,
            BusinessEntityBeanGenerator.class

            ));

    protected List<Class<? extends WikengoCommonGenerator>> getGenerators() {
        List<Class<? extends WikengoCommonGenerator>> result =  DEFAULT_GENERATORS;
        Properties props = null;
        try {
            Properties tmpProperties = Resource.getConfigProperties("WikittyMetaGenerator.properties");

            props = new Properties();

            // Mise Ã  plat du fichier (sans parent)
            for (Enumeration<?> e = tmpProperties.propertyNames(); e.hasMoreElements();) {
                String key = e.nextElement() + "";
                String value = tmpProperties.getProperty(key);
                props.setProperty(key, value);
            }

        } catch (IOException ioe) {
            log.error("Unable to load file WikengoMetaGenerator.properties : " + ioe.getMessage());
        }

        if (props != null) {
            List<Class<? extends WikengoCommonGenerator>> propsGenerators = new ArrayList<Class<? extends WikengoCommonGenerator>>();
            String basePackage = props.getProperty("basePackage");
            String suffix = props.getProperty("suffix");
            if (basePackage != null && !basePackage.endsWith(".")) {
                basePackage += ".";
            }
            for (Object key : props.keySet()) {
                String className = (String)key;
                if ( suffix != null ) className += suffix;

                // Try with "className"
                Class<? extends WikengoCommonGenerator> clazz = getClass(className);

                // Try with "baseName.className"
                if (clazz == null && basePackage != null) {
                    clazz = getClass(basePackage + className);
                }

                if (clazz != null) {
                    propsGenerators.add(clazz);
                } else {
                    log.warn("No generator found for property '" + className + "'");
                }
            }
            if (!propsGenerators.isEmpty()) {
                result = propsGenerators;
            }
        }

        log.warn("Enabled generators: " + result);
        return result;
    }

    protected Class<? extends WikengoCommonGenerator> getClass(String className) {
        Class<? extends WikengoCommonGenerator> result = null;
        try {
            Class<?> clazz = Class.forName(className);
            if (WikengoCommonGenerator.class.isAssignableFrom(clazz)) {
                result = (Class<? extends WikengoCommonGenerator>)clazz;
            }
        } catch (ClassNotFoundException e) {
            // Nothing to do
        }
        return result;
    }

    @Override
    public void generate(ObjectModel model, File destDir) throws IOException {
        for (Class<? extends ObjectModelGenerator> generatorClass : getGenerators()) {
            ObjectModelGenerator generator;
            if (excludeTemplates != null && excludeTemplates.contains(generatorClass.getName())) {
                // exclude generator
                log.info("exclude generator " + generatorClass);
                continue;
            }
            try {

                generator = generatorClass.newInstance();
                generator.setParent(this);

            } catch (Exception e) {
                // should never happens
                if (log.isErrorEnabled()) {
                    log.error("An error occurs when generating persistence", e);
                }
                throw new RuntimeException(e);
            }

            // log
            if (log.isDebugEnabled()) {
                log.debug("call template : " + generatorClass.getSimpleName());
            }
            generator.generate(model, destDir);
        }
    }

}
