/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.internal.Base64Encoder;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.support.events.AbstractWebDriverEventListener;

public class SnapshotScreenListener
extends AbstractWebDriverEventListener {
    private final Session session;

    public SnapshotScreenListener(Session session) {
        this.session = session;
    }

    public void onException(Throwable throwable, WebDriver driver) {
        if (Platform.getCurrent().is(Platform.ANDROID)) {
            return;
        }
        try {
            this.workAroundD3dBugInVista();
            Rectangle size = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
            BufferedImage image = new Robot().createScreenCapture(size);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", outputStream);
            String encoded = new Base64Encoder().encode(outputStream.toByteArray());
            this.session.attachScreenshot(encoded);
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    private void workAroundD3dBugInVista() {
        if (Platform.getCurrent().is(Platform.WINDOWS)) {
            System.setProperty("sun.java2d.d3d", "false");
        }
    }
}

