/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.BufferedReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.HttpSessionId;
import org.openqa.selenium.remote.JsonToBeanConverter;
import org.openqa.selenium.remote.PropertyMunger;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.SessionNotFoundException;
import org.openqa.selenium.remote.SimplePropertyDescriptor;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.HttpRequest;
import org.openqa.selenium.remote.server.HttpResponse;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.DeleteSession;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;
import org.openqa.selenium.remote.server.log.LoggingManager;
import org.openqa.selenium.remote.server.log.PerSessionLogHandler;
import org.openqa.selenium.remote.server.rest.Renderer;
import org.openqa.selenium.remote.server.rest.RestishHandler;
import org.openqa.selenium.remote.server.rest.Result;
import org.openqa.selenium.remote.server.rest.ResultType;

public class ResultConfig {
    private final String[] sections;
    private final HandlerFactory handlerFactory;
    private final DriverSessions sessions;
    private final Multimap<ResultType, Result> resultToRender = LinkedHashMultimap.create();
    private final String url;
    private final Logger log;

    public ResultConfig(String url, Class<? extends RestishHandler> handlerClazz, DriverSessions sessions, Logger log) {
        this.url = url;
        this.log = log;
        if (url == null || handlerClazz == null) {
            throw new IllegalArgumentException("You must specify the handler and the url");
        }
        this.sections = url.split("/");
        this.sessions = sessions;
        this.handlerFactory = this.getHandlerFactory(handlerClazz);
    }

    public RestishHandler getHandler(String url, SessionId sessionId) throws Exception {
        if (!this.isFor(url)) {
            return null;
        }
        return this.populate(this.handlerFactory.createHandler(sessionId), url);
    }

    public boolean isFor(String urlToMatch) {
        if (urlToMatch == null) {
            return this.sections.length == 0;
        }
        String[] allParts = urlToMatch.split("/");
        if (this.sections.length != allParts.length) {
            return false;
        }
        for (int i = 0; i < this.sections.length; ++i) {
            if (this.sections[i].startsWith(":") || this.sections[i].equals(allParts[i])) continue;
            return false;
        }
        return true;
    }

    protected RestishHandler populate(RestishHandler handler, String pathString) {
        if (pathString == null) {
            return handler;
        }
        String[] strings = pathString.split("/");
        for (int i = 0; i < this.sections.length; ++i) {
            if (!this.sections[i].startsWith(":")) continue;
            try {
                PropertyMunger.set((String)this.sections[i].substring(1), (Object)handler, (Object)strings[i]);
                continue;
            }
            catch (Exception e) {
                throw new WebDriverException((Throwable)e);
            }
        }
        return handler;
    }

    public ResultConfig on(ResultType resultType, Renderer renderer) {
        return this.on(resultType, renderer, "");
    }

    public ResultConfig on(ResultType success, Renderer renderer, String mimeType) {
        return this.on(success, new Result(mimeType, renderer));
    }

    public ResultConfig on(ResultType type, Result result) {
        for (Result existingResult : this.resultToRender.get((Object)type)) {
            assert (!existingResult.isExactMimeTypeMatch(result.getMimeType()));
        }
        this.resultToRender.put((Object)type, (Object)result);
        return this;
    }

    public void handle(String pathInfo, final HttpRequest request, final HttpResponse response) throws Exception {
        ResultType result;
        String sessionId = HttpSessionId.getSessionId((String)request.getUri());
        SessionId sessId = sessionId != null ? new SessionId(sessionId) : null;
        this.throwUpIfSessionTerminated(sessId);
        final RestishHandler handler = this.getHandler(pathInfo, sessId);
        if (handler instanceof JsonParametersAware) {
            this.setJsonParameters(request, handler);
        }
        request.setAttribute("handler", handler);
        this.throwUpIfSessionTerminated(sessId);
        try {
            if ("/status".equals(pathInfo)) {
                this.log.fine(String.format("Executing: %s at URL: %s)", handler.toString(), pathInfo));
            } else {
                this.log.info(String.format("Executing: %s at URL: %s)", handler.toString(), pathInfo));
            }
            result = handler.handle();
            this.addHandlerAttributesToRequest(request, handler);
            if ("/status".equals(pathInfo)) {
                this.log.fine("Done: " + pathInfo);
            } else {
                this.log.info("Done: " + pathInfo);
            }
        }
        catch (UnreachableBrowserException e) {
            this.throwUpIfSessionTerminated(sessId);
            this.replyError(request, response, (Exception)((Object)e));
            return;
        }
        catch (SessionNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            result = ResultType.EXCEPTION;
            this.log.log(Level.WARNING, "Exception thrown", e);
            Throwable toUse = this.getRootExceptionCause(e);
            this.log.warning("Exception: " + toUse.getMessage());
            request.setAttribute("exception", toUse);
            if (handler instanceof WebDriverHandler) {
                request.setAttribute("screen", ((WebDriverHandler)handler).getScreenshot());
            }
        }
        catch (Error e) {
            this.log.info("Error: " + e.getMessage());
            result = ResultType.EXCEPTION;
            request.setAttribute("exception", e);
        }
        final Renderer renderer = this.getRenderer(result, request);
        if (handler instanceof WebDriverHandler) {
            FutureTask<ResultType> task = new FutureTask<ResultType>(new Callable<ResultType>(){

                @Override
                public ResultType call() throws Exception {
                    renderer.render(request, response, handler);
                    response.end();
                    return null;
                }
            });
            try {
                ((WebDriverHandler)handler).execute(task);
                task.get();
            }
            catch (RejectedExecutionException e) {
                throw new SessionNotFoundException();
            }
            if (handler instanceof DeleteSession) {
                PerSessionLogHandler logHandler = LoggingManager.perSessionLogHandler();
                logHandler.transferThreadTempLogsToSessionLogs(sessId);
                logHandler.removeSessionLogs(sessId);
                this.sessions.deleteSession(sessId);
            }
        } else {
            renderer.render(request, response, handler);
            response.end();
        }
    }

    private void replyError(HttpRequest request, HttpResponse response, Exception e) throws Exception {
        Renderer renderer2 = this.getRenderer(ResultType.EXCEPTION, request);
        request.setAttribute("exception", e);
        renderer2.render(request, response, null);
    }

    private void throwUpIfSessionTerminated(SessionId sessId) throws Exception {
        boolean isTerminated;
        if (sessId == null) {
            return;
        }
        Session session = this.sessions.get(sessId);
        boolean bl = isTerminated = session == null;
        if (isTerminated) {
            throw new SessionNotFoundException();
        }
    }

    @VisibleForTesting
    Renderer getRenderer(ResultType resultType, HttpRequest request) {
        Collection results = (Collection)Preconditions.checkNotNull((Object)this.resultToRender.get((Object)resultType));
        Result tempToUse = null;
        for (Result res : results) {
            if ((tempToUse != null || res.isOnlyForExactMatch()) && !res.isExactMimeTypeMatch(request.getHeader("Accept"))) continue;
            tempToUse = res;
        }
        return ((Result)Preconditions.checkNotNull(tempToUse)).getRenderer();
    }

    private void setJsonParameters(HttpRequest request, RestishHandler handler) throws Exception {
        BufferedReader reader = new BufferedReader(request.getReader());
        StringBuilder builder = new StringBuilder();
        String line = reader.readLine();
        while (line != null) {
            builder.append(line);
            line = reader.readLine();
        }
        String raw = builder.toString();
        if (raw.length() > 0) {
            Map parameters = (Map)new JsonToBeanConverter().convert(HashMap.class, (Object)builder.toString());
            ((JsonParametersAware)((Object)handler)).setJsonParameters(parameters);
        }
    }

    protected void addHandlerAttributesToRequest(HttpRequest request, RestishHandler handler) throws Exception {
        SimplePropertyDescriptor[] properties;
        for (SimplePropertyDescriptor property : properties = SimplePropertyDescriptor.getPropertyDescriptors(handler.getClass())) {
            Method readMethod = property.getReadMethod();
            if (readMethod == null) continue;
            Object result = readMethod.invoke((Object)handler, new Object[0]);
            request.setAttribute(property.getName(), result);
        }
    }

    public Throwable getRootExceptionCause(Throwable originalException) {
        Throwable toReturn = originalException;
        if (originalException instanceof UndeclaredThrowableException) {
            toReturn = originalException.getCause().getCause();
        }
        ArrayList chain = Lists.newArrayListWithExpectedSize((int)10);
        for (Throwable current = toReturn; current != null && chain.size() < 10; current = current.getCause()) {
            chain.add(current);
        }
        if (chain.isEmpty()) {
            return null;
        }
        ErrorCodes ec = new ErrorCodes();
        Iterator reversedChain = Lists.reverse((List)chain).iterator();
        Throwable rootCause = (Throwable)reversedChain.next();
        if (!reversedChain.hasNext() || ec.isMappableError(rootCause)) {
            return rootCause;
        }
        Throwable nextCause = (Throwable)reversedChain.next();
        return ec.isMappableError(nextCause) ? nextCause : rootCause;
    }

    private HandlerFactory getHandlerFactory(Class<? extends RestishHandler> handlerClazz) {
        final Constructor<? extends RestishHandler> sessionAware = ResultConfig.getConstructor(handlerClazz, Session.class);
        if (sessionAware != null) {
            return new HandlerFactory(){

                @Override
                public RestishHandler createHandler(SessionId sessionId) throws Exception {
                    return (RestishHandler)sessionAware.newInstance(sessionId != null ? ResultConfig.this.sessions.get(sessionId) : null);
                }
            };
        }
        final Constructor<? extends RestishHandler> driverSessions = ResultConfig.getConstructor(handlerClazz, DriverSessions.class);
        if (driverSessions != null) {
            return new HandlerFactory(){

                @Override
                public RestishHandler createHandler(SessionId sessionId) throws Exception {
                    return (RestishHandler)driverSessions.newInstance(ResultConfig.this.sessions);
                }
            };
        }
        final Constructor<? extends RestishHandler> norags = ResultConfig.getConstructor(handlerClazz, new Class[0]);
        if (norags != null) {
            return new HandlerFactory(){

                @Override
                public RestishHandler createHandler(SessionId sessionId) throws Exception {
                    return (RestishHandler)norags.newInstance(new Object[0]);
                }
            };
        }
        throw new IllegalArgumentException("Don't know how to construct " + handlerClazz);
    }

    private static Constructor<? extends RestishHandler> getConstructor(Class<? extends RestishHandler> handlerClazz, Class ... types) {
        try {
            return handlerClazz.getConstructor(types);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResultConfig)) {
            return false;
        }
        ResultConfig that = (ResultConfig)o;
        return this.url.equals(that.url);
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    static interface HandlerFactory {
        public RestishHandler createHandler(SessionId var1) throws Exception;
    }
}

