/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet.handler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.ByteStreams;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.openqa.grid.common.SeleniumProtocol;
import org.openqa.grid.internal.ExternalSessionKey;
import org.openqa.grid.internal.Registry;
import org.openqa.grid.internal.TestSession;
import org.openqa.grid.web.servlet.handler.LegacySeleniumRequest;
import org.openqa.grid.web.servlet.handler.RequestType;
import org.openqa.grid.web.servlet.handler.WebDriverRequest;

public abstract class SeleniumBasedRequest
extends HttpServletRequestWrapper {
    private byte[] body;
    private final Registry registry;
    private final RequestType type;
    private final String encoding = "UTF-8";
    private final Map<String, Object> desiredCapability;
    private final long timestamp = System.currentTimeMillis();

    public static SeleniumBasedRequest createFromRequest(HttpServletRequest request, Registry registry) {
        if (SeleniumBasedRequest.getRequestProtocol(request) == SeleniumProtocol.Selenium) {
            return new LegacySeleniumRequest(request, registry);
        }
        return new WebDriverRequest(request, registry);
    }

    public static SeleniumProtocol getRequestProtocol(HttpServletRequest request) {
        if ("/selenium-server/driver".equals(request.getServletPath())) {
            return SeleniumProtocol.Selenium;
        }
        return SeleniumProtocol.WebDriver;
    }

    @VisibleForTesting
    public SeleniumBasedRequest(HttpServletRequest request, Registry registry, RequestType type, Map<String, Object> desiredCapability) {
        super(request);
        this.registry = registry;
        this.type = type;
        this.desiredCapability = desiredCapability;
    }

    public SeleniumBasedRequest(HttpServletRequest httpServletRequest, Registry registry) {
        super(httpServletRequest);
        try {
            ServletInputStream is = super.getInputStream();
            this.setBody(ByteStreams.toByteArray((InputStream)is));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.registry = registry;
        this.type = this.extractRequestType();
        this.desiredCapability = this.type == RequestType.START_SESSION ? this.extractDesiredCapability() : null;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public abstract RequestType extractRequestType();

    public abstract ExternalSessionKey extractSession();

    public abstract Map<String, Object> extractDesiredCapability();

    public abstract String getNewSessionRequestedCapability(TestSession var1);

    public RequestType getRequestType() {
        return this.type;
    }

    public ServletInputStream getInputStream() throws IOException {
        return new ServletInputStreamImpl(new ByteArrayInputStream(this.body));
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), "UTF-8"));
    }

    public int getContentLength() {
        if (this.body == null) {
            return 0;
        }
        return this.body.length;
    }

    public String getBody() {
        try {
            Charset charset = Charset.forName("UTF-8");
            CharsetDecoder decoder = charset.newDecoder();
            CharBuffer cbuf = decoder.decode(ByteBuffer.wrap(this.body));
            return cbuf.toString();
        }
        catch (CharacterCodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setBody(String content) {
        this.setBody(content.getBytes());
    }

    public void setBody(byte[] content) {
        this.body = content;
        this.setAttribute("Content-Length", content.length);
    }

    public long getCreationTime() {
        return this.timestamp;
    }

    public String toString() {
        SimpleDateFormat format = new SimpleDateFormat("d MMM yyyy HH:mm:ss");
        StringBuilder builder = new StringBuilder();
        builder.append("[" + format.format(new Date(this.timestamp)) + "] ");
        builder.append(this.getMethod().toUpperCase() + " " + this.getPathInfo() + "   ");
        if (this.getBody() != null && !this.getBody().isEmpty()) {
            builder.append(this.getBody());
        }
        return builder.toString();
    }

    public Map<String, Object> getDesiredCapabilities() {
        return this.desiredCapability;
    }

    private class ServletInputStreamImpl
    extends ServletInputStream {
        private InputStream is;

        public ServletInputStreamImpl(InputStream is) {
            this.is = is;
        }

        public int read() throws IOException {
            return this.is.read();
        }

        public boolean markSupported() {
            return false;
        }

        public synchronized void mark(int i) {
            throw new RuntimeException("not implemented");
        }

        public synchronized void reset() throws IOException {
            throw new RuntimeException("not implemented");
        }
    }
}

