/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;
import org.openqa.selenium.remote.server.rest.ResultType;

public class ConfigureTimeout
extends WebDriverHandler
implements JsonParametersAware {
    private volatile String type;
    private volatile long millis;

    public ConfigureTimeout(Session session) {
        super(session);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        this.type = (String)allParameters.get("type");
        try {
            this.millis = ((Number)allParameters.get("ms")).longValue();
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Illegal (non-numeric) timeout value passed: " + allParameters.get("ms"), (Throwable)ex);
        }
    }

    @Override
    public ResultType call() throws Exception {
        if ("implicit".equals(this.type)) {
            this.getDriver().manage().timeouts().implicitlyWait(this.millis, TimeUnit.MILLISECONDS);
        } else if ("page load".equals(this.type)) {
            this.getDriver().manage().timeouts().pageLoadTimeout(this.millis, TimeUnit.MILLISECONDS);
        } else if ("script".equals(this.type)) {
            this.getDriver().manage().timeouts().setScriptTimeout(this.millis, TimeUnit.MILLISECONDS);
        } else {
            throw new WebDriverException("Unknown wait type: " + this.type);
        }
        return ResultType.SUCCESS;
    }

    public String toString() {
        return String.format("[%s wait: %s]", this.type, this.millis);
    }
}

