/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.grid.common.CommandLineOptionHelper;
import org.openqa.grid.common.GridRole;
import org.openqa.grid.common.JSONConfigurationUtils;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.cli.RemoteControlLauncher;

public class GridNodeConfiguration {
    private GridRole role;
    private List<DesiredCapabilities> capabilities = new ArrayList<DesiredCapabilities>();
    private Map<String, Object> configuration = new HashMap<String, Object>();
    public static final String HOST = "host";
    public static final String HUB_HOST = "hubHost";
    public static final String PORT = "port";
    public static final String CYCLE = "cleanupCycle";
    public static final String TIME_OUT = "timeout";
    public static final String MAX_CONCURRENT = "maxConcurrent";
    public static final String SERVLETS = "servlets";
    private String[] args;
    private String nodeJSON;

    public static GridNodeConfiguration build(String[] args) {
        GridNodeConfiguration res = new GridNodeConfiguration();
        res.args = args;
        CommandLineOptionHelper helper = new CommandLineOptionHelper(args);
        res.role = GridRole.find(args);
        String defaultConfig = "defaults/WebDriverDefaultNode.json";
        res.loadFromJSON(defaultConfig);
        if (helper.isParamPresent("-nodeConfig")) {
            String value;
            res.nodeJSON = value = helper.getParamValue("-nodeConfig");
            res.loadFromJSON(value);
        }
        res.loadFromCommandLine(args);
        return res;
    }

    private void loadFromCommandLine(String[] args) {
        List<String> l;
        CommandLineOptionHelper helper = new CommandLineOptionHelper(args);
        if (helper.isParamPresent("-host")) {
            this.configuration.put(HOST, helper.getParamValue("-host"));
        }
        if (helper.isParamPresent("-port")) {
            this.configuration.put(PORT, Integer.parseInt(helper.getParamValue("-port")));
        }
        if (helper.isParamPresent("-cleanUpCycle")) {
            this.configuration.put(CYCLE, Integer.parseInt(helper.getParamValue("-cleanUpCycle")));
        }
        if (helper.isParamPresent("-timeout")) {
            this.configuration.put(TIME_OUT, Integer.parseInt(helper.getParamValue("-timeout")));
        }
        if (helper.isParamPresent("-maxSession")) {
            this.configuration.put(MAX_CONCURRENT, Integer.parseInt(helper.getParamValue("-maxSession")));
        }
        if (helper.isParamPresent("-servlets")) {
            this.configuration.put(SERVLETS, helper.getParamValue("-servlets"));
        }
        if (!(l = helper.getParamValues("-browser")).isEmpty()) {
            for (String s : l) {
                DesiredCapabilities c = this.addCapabilityFromString(s);
                this.capabilities.add(c);
            }
        }
    }

    private DesiredCapabilities addCapabilityFromString(String capability) {
        String[] s = capability.split(",");
        if (s.length == 0) {
            throw new GridConfigurationException("-browser must be followed by a browser description");
        }
        DesiredCapabilities res = new DesiredCapabilities();
        for (String capabilityPair : s) {
            if (capabilityPair.split("=").length != 2) {
                throw new GridConfigurationException("-browser format is key1=value1,key2=value2 " + capabilityPair + " doesn't follow that format.");
            }
            String key = capabilityPair.split("=")[0];
            String value = capabilityPair.split("=")[1];
            res.setCapability(key, value);
        }
        if (res.getBrowserName() == null) {
            throw new GridConfigurationException("You need to specify a browserName using browserName=XXX");
        }
        return res;
    }

    public JSONObject getRegistrationRequest() {
        try {
            JSONObject res = new JSONObject();
            JSONArray a = new JSONArray();
            for (DesiredCapabilities cap : this.capabilities) {
                JSONObject capa = new JSONObject(cap.asMap());
                a.put((Object)capa);
            }
            res.put("configuration", (Object)new JSONObject(this.configuration));
            return res;
        }
        catch (JSONException e) {
            throw new GridConfigurationException("error generating the node config : " + e.getMessage());
        }
    }

    private void loadFromJSON(String resource) {
        try {
            JSONObject base = JSONConfigurationUtils.loadJSON(resource);
            if (base.has("capabilities")) {
                this.capabilities = new ArrayList<DesiredCapabilities>();
                JSONArray a = base.getJSONArray("capabilities");
                for (int i = 0; i < a.length(); ++i) {
                    JSONObject cap = a.getJSONObject(i);
                    DesiredCapabilities c = new DesiredCapabilities();
                    Iterator iterator = cap.keys();
                    while (iterator.hasNext()) {
                        String name = (String)iterator.next();
                        c.setCapability(name, cap.get(name));
                    }
                }
            }
            JSONObject o = base.getJSONObject("configuration");
            Iterator iterator = o.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                Object value = o.get(key);
                if (value instanceof JSONArray) {
                    JSONArray a = (JSONArray)value;
                    ArrayList<String> as = new ArrayList<String>();
                    for (int i = 0; i < a.length(); ++i) {
                        as.add(a.getString(i));
                    }
                    this.configuration.put(key, as);
                    continue;
                }
                this.configuration.put(key, o.get(key));
            }
        }
        catch (Throwable e) {
            throw new GridConfigurationException("Error with the JSON of the config : " + e.getMessage(), e);
        }
    }

    public GridRole getRole() {
        return this.role;
    }

    public void setRole(GridRole role) {
        this.role = role;
    }

    public RemoteControlConfiguration getRemoteControlConfiguration() {
        return RemoteControlLauncher.parseLauncherOptions(this.args);
    }

    public String[] getArgs() {
        return this.args;
    }

    public List<DesiredCapabilities> getCapabilities() {
        return this.capabilities;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public String getHost() {
        return (String)this.configuration.get(HOST);
    }

    public int getPort() {
        return (Integer)this.configuration.get(PORT);
    }

    public String getHubHost() {
        return (String)this.configuration.get(HUB_HOST);
    }
}

