/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal;

import com.google.common.io.ByteStreams;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.util.EntityUtils;
import org.openqa.grid.common.exception.ClientGoneException;
import org.openqa.grid.common.exception.GridException;
import org.openqa.grid.internal.ExternalSessionKey;
import org.openqa.grid.internal.Registry;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.SessionTerminationReason;
import org.openqa.grid.internal.TestSlot;
import org.openqa.grid.internal.TimeSource;
import org.openqa.grid.internal.listeners.CommandListener;
import org.openqa.grid.web.Hub;
import org.openqa.grid.web.servlet.handler.LegacySeleniumRequest;
import org.openqa.grid.web.servlet.handler.RequestType;
import org.openqa.grid.web.servlet.handler.SeleniumBasedRequest;
import org.openqa.grid.web.servlet.handler.SeleniumBasedResponse;
import org.openqa.grid.web.servlet.handler.WebDriverRequest;
import org.openqa.selenium.io.IOUtils;

public class TestSession {
    private static final Logger log = Logger.getLogger(TestSession.class.getName());
    static final int MAX_IDLE_TIME_BEFORE_CONSIDERED_ORPHANED = 5000;
    private final String internalKey;
    private final TestSlot slot;
    private volatile ExternalSessionKey externalKey = null;
    private volatile long sessionCreatedAt;
    private volatile long lastActivity;
    private final Map<String, Object> requestedCapabilities;
    private Map<String, Object> objects = Collections.synchronizedMap(new HashMap());
    private volatile boolean ignoreTimeout = false;
    private final TimeSource timeSource;
    private volatile boolean forwardingRequest;
    private final int MAX_NETWORK_LATENCY = 1000;

    public String getInternalKey() {
        return this.internalKey;
    }

    public TestSession(TestSlot slot, Map<String, Object> requestedCapabilities, TimeSource timeSource) {
        this.internalKey = UUID.randomUUID().toString();
        this.slot = slot;
        this.requestedCapabilities = requestedCapabilities;
        this.timeSource = timeSource;
        this.lastActivity = this.timeSource.currentTimeInMillis();
    }

    public Map<String, Object> getRequestedCapabilities() {
        return this.requestedCapabilities;
    }

    public ExternalSessionKey getExternalKey() {
        return this.externalKey;
    }

    public void setExternalKey(ExternalSessionKey externalKey) {
        this.externalKey = externalKey;
        this.sessionCreatedAt = this.lastActivity;
    }

    public long getInactivityTime() {
        if (this.ignoreTimeout) {
            return 0L;
        }
        return this.timeSource.currentTimeInMillis() - this.lastActivity;
    }

    public boolean isOrphaned() {
        long elapsedSinceCreation = this.timeSource.currentTimeInMillis() - this.sessionCreatedAt;
        return this.slot.getProtocol().isSelenium() && elapsedSinceCreation > 5000L && this.sessionCreatedAt == this.lastActivity;
    }

    public TestSlot getSlot() {
        return this.slot;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.internalKey == null ? 0 : this.internalKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestSession other = (TestSession)obj;
        return this.internalKey.equals(other.internalKey);
    }

    public String toString() {
        return this.externalKey != null ? "ext. key " + this.externalKey : this.internalKey + " (int. key, remote not contacted yet.)";
    }

    private HttpClient getClient() {
        Registry reg = this.slot.getProxy().getRegistry();
        int browserTimeout = reg.getConfiguration().getBrowserTimeout();
        if (browserTimeout > 0) {
            int selenium_server_cleanup_cycle = browserTimeout / 10;
            browserTimeout += selenium_server_cleanup_cycle + 1000;
            browserTimeout *= 2;
        }
        return this.slot.getProxy().getHttpClientFactory().getGridHttpClient(browserTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String forward(SeleniumBasedRequest request, HttpServletResponse response, boolean newSessionRequest) throws IOException {
        String res = null;
        String currentThreadName = Thread.currentThread().getName();
        this.setThreadDisplayName();
        this.forwardingRequest = true;
        try {
            if (this.slot.getProxy() instanceof CommandListener) {
                ((CommandListener)((Object)this.slot.getProxy())).beforeCommand(this, (HttpServletRequest)request, response);
            }
            this.lastActivity = this.timeSource.currentTimeInMillis();
            HttpRequest proxyRequest = this.prepareProxyRequest((HttpServletRequest)request);
            HttpResponse proxyResponse = this.sendRequestToNode(proxyRequest);
            this.lastActivity = this.timeSource.currentTimeInMillis();
            int statusCode = proxyResponse.getStatusLine().getStatusCode();
            response.setStatus(statusCode);
            this.processResponseHeaders((HttpServletRequest)request, response, this.slot.getRemoteURL(), proxyResponse);
            if (statusCode != 500 && statusCode != 404) {
                this.updateHubIfNewWebDriverSession(request, proxyResponse);
            }
            if (newSessionRequest && statusCode == 500) {
                this.removeIncompleteNewSessionRequest();
            }
            if (statusCode == 404) {
                this.removeSessionBrowserTimeout();
            }
            HttpEntity responseBody = proxyResponse.getEntity();
            byte[] contentBeingForwarded = null;
            if (responseBody != null) {
                try {
                    InputStream in = responseBody.getContent();
                    if (request.getRequestType() == RequestType.START_SESSION && request instanceof LegacySeleniumRequest) {
                        res = this.getResponseUtf8Content(in);
                        this.updateHubNewSeleniumSession(res);
                        in = new ByteArrayInputStream(res.getBytes("UTF-8"));
                    }
                    byte[] bytes = this.drainInputStream(in);
                    this.writeRawBody(response, bytes);
                }
                finally {
                    EntityUtils.consume((HttpEntity)responseBody);
                }
            }
            if (this.slot.getProxy() instanceof CommandListener) {
                SeleniumBasedResponse wrappedResponse = new SeleniumBasedResponse(response);
                wrappedResponse.setForwardedContent(contentBeingForwarded);
                ((CommandListener)((Object)this.slot.getProxy())).afterCommand(this, (HttpServletRequest)request, (HttpServletResponse)wrappedResponse);
            }
            response.flushBuffer();
            String string = res;
            return string;
        }
        finally {
            this.forwardingRequest = false;
            Thread.currentThread().setName(currentThreadName);
        }
    }

    private void setThreadDisplayName() {
        DateFormat dfmt = DateFormat.getTimeInstance();
        String name = "Forwarding " + this + " to " + this.slot.getRemoteURL() + " at " + dfmt.format(Calendar.getInstance().getTime());
        Thread.currentThread().setName(name);
    }

    private void removeIncompleteNewSessionRequest() {
        RemoteProxy proxy = this.slot.getProxy();
        proxy.getRegistry().terminate(this, SessionTerminationReason.CREATIONFAILED);
    }

    private void removeSessionBrowserTimeout() {
        RemoteProxy proxy = this.slot.getProxy();
        proxy.getRegistry().terminate(this, SessionTerminationReason.BROWSER_TIMEOUT);
    }

    private void updateHubNewSeleniumSession(String content) {
        ExternalSessionKey key = ExternalSessionKey.fromResponseBody(content);
        this.setExternalKey(key);
    }

    private void updateHubIfNewWebDriverSession(SeleniumBasedRequest request, HttpResponse proxyResponse) {
        if (request.getRequestType() == RequestType.START_SESSION && request instanceof WebDriverRequest) {
            Header h = proxyResponse.getFirstHeader("Location");
            if (h == null) {
                throw new GridException("new session request for webdriver should contain a location header with the session.");
            }
            ExternalSessionKey key = ExternalSessionKey.fromWebDriverRequest(h.getValue());
            this.setExternalKey(key);
        }
    }

    private HttpResponse sendRequestToNode(HttpRequest proxyRequest) throws ClientProtocolException, IOException {
        HttpClient client = this.getClient();
        URL remoteURL = this.slot.getRemoteURL();
        HttpHost host = new HttpHost(remoteURL.getHost(), remoteURL.getPort());
        return client.execute(host, proxyRequest);
    }

    private HttpRequest prepareProxyRequest(HttpServletRequest request) throws IOException {
        BasicHttpRequest proxyRequest;
        URL remoteURL = this.slot.getRemoteURL();
        String pathSpec = request.getServletPath() + request.getContextPath();
        String path = request.getRequestURI();
        if (!path.startsWith(pathSpec)) {
            throw new IllegalStateException("Expected path " + path + " to start with pathSpec " + pathSpec);
        }
        String end = path.substring(pathSpec.length());
        String ok = remoteURL + end + "?" + request.getQueryString();
        String uri = new URL(remoteURL, ok).toExternalForm();
        ServletInputStream body = null;
        if (request.getContentLength() > 0 || request.getHeader("Transfer-Encoding") != null) {
            body = request.getInputStream();
        }
        if (body != null) {
            BasicHttpEntityEnclosingRequest r = new BasicHttpEntityEnclosingRequest(request.getMethod(), uri);
            r.setEntity((HttpEntity)new InputStreamEntity((InputStream)body, (long)request.getContentLength()));
            proxyRequest = r;
        } else {
            proxyRequest = new BasicHttpRequest(request.getMethod(), uri);
        }
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            String headerName = (String)e.nextElement();
            if ("Content-Length".equalsIgnoreCase(headerName)) continue;
            proxyRequest.setHeader(headerName, request.getHeader(headerName));
        }
        return proxyRequest;
    }

    private void writeRawBody(HttpServletResponse response, byte[] rawBody) throws IOException {
        ServletOutputStream out = response.getOutputStream();
        try {
            if (!response.containsHeader("Content-Length")) {
                response.setIntHeader("Content-Length", rawBody.length);
            }
            out.write(rawBody);
        }
        catch (IOException e) {
            throw new ClientGoneException(e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] drainInputStream(InputStream in) throws IOException {
        try {
            byte[] byArray = ByteStreams.toByteArray((InputStream)in);
            return byArray;
        }
        finally {
            in.close();
        }
    }

    private String getResponseUtf8Content(InputStream in) {
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            in.close();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String res = sb.toString();
        return res;
    }

    private void processResponseHeaders(HttpServletRequest request, HttpServletResponse response, URL remoteURL, HttpResponse proxyResponse) throws MalformedURLException {
        String pathSpec = request.getServletPath() + request.getContextPath();
        for (Header header : proxyResponse.getAllHeaders()) {
            String name = header.getName();
            String value = header.getValue();
            if (name.equalsIgnoreCase("Transfer-Encoding") && value.equalsIgnoreCase("chunked")) continue;
            if (name.equalsIgnoreCase("Location")) {
                URL returnedLocation = new URL(value);
                String driverPath = remoteURL.getPath();
                String wrongPath = returnedLocation.getPath();
                String correctPath = wrongPath.replace(driverPath, "");
                Hub hub = this.slot.getProxy().getRegistry().getHub();
                String location = "http://" + hub.getHost() + ":" + hub.getPort() + pathSpec + correctPath;
                response.setHeader(name, location);
                continue;
            }
            response.setHeader(name, value);
        }
    }

    public Object get(String key) {
        return this.objects.get(key);
    }

    public void put(String key, Object value) {
        this.objects.put(key, value);
    }

    public boolean sendDeleteSessionRequest() {
        boolean ok;
        BasicHttpRequest request;
        URL remoteURL = this.slot.getRemoteURL();
        switch (this.slot.getProtocol()) {
            case Selenium: {
                request = new BasicHttpRequest("POST", remoteURL.toExternalForm() + "/?cmd=testComplete&sessionId=" + this.getExternalKey().getKey());
                break;
            }
            case WebDriver: {
                String uri = remoteURL.toString() + "/session/" + this.externalKey;
                request = new BasicHttpRequest("DELETE", uri);
                break;
            }
            default: {
                throw new GridException("Error, protocol not implemented.");
            }
        }
        HttpHost host = new HttpHost(remoteURL.getHost(), remoteURL.getPort());
        try {
            HttpClient client = this.getClient();
            HttpResponse response = client.execute(host, (HttpRequest)request);
            int code = response.getStatusLine().getStatusCode();
            ok = code >= 200 && code <= 299;
        }
        catch (Throwable e) {
            ok = false;
            log.severe("Error releasing. Server corrupted ?");
        }
        return ok;
    }

    public void setIgnoreTimeout(boolean ignore) {
        if (!ignore) {
            this.lastActivity = this.timeSource.currentTimeInMillis();
        }
        this.ignoreTimeout = ignore;
    }

    public boolean isForwardingRequest() {
        return this.forwardingRequest;
    }
}

