/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.openqa.selenium.server.BrowserResponseSequencer;
import org.openqa.selenium.server.CommandHolder;
import org.openqa.selenium.server.CommandResultHolder;
import org.openqa.selenium.server.DefaultRemoteCommand;
import org.openqa.selenium.server.FrameAddress;
import org.openqa.selenium.server.FrameGroupCommandQueueSet;
import org.openqa.selenium.server.InjectionHelper;
import org.openqa.selenium.server.RemoteCommand;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.WindowClosedException;

public class CommandQueue {
    private static Logger log = Logger.getLogger(CommandQueue.class.getName());
    private static AtomicInteger millisecondDelayBetweenOperations = new AtomicInteger(System.getProperty("selenium.slowMode") == null ? 0 : Integer.parseInt(System.getProperty("selenium.slowMode")));
    private static AtomicInteger idGenerator = new AtomicInteger(0);
    private final AtomicLong defaultTimeout;
    private static AtomicInteger retryTimeout = new AtomicInteger(10);
    private final BrowserResponseSequencer browserResponseSequencer;
    private final String sessionId;
    private final String uniqueId;
    private final boolean proxyInjectionMode;
    private CommandHolder commandHolder;
    private CommandResultHolder resultHolder;
    private AtomicBoolean resultExpected;
    private ConcurrentHashMap<String, Boolean> cachedJsVariableNamesPointingAtThisWindow;
    private FrameAddress frameAddress;
    private AtomicBoolean closed;
    private AtomicInteger queueDelay;

    public CommandQueue(String newSessionId, String newUniqueId, RemoteControlConfiguration configuration) {
        this.sessionId = newSessionId;
        this.uniqueId = newUniqueId;
        this.proxyInjectionMode = configuration.getProxyInjectionModeArg();
        this.browserResponseSequencer = new BrowserResponseSequencer(newUniqueId);
        this.resultExpected = new AtomicBoolean(false);
        this.closed = new AtomicBoolean(false);
        this.cachedJsVariableNamesPointingAtThisWindow = new ConcurrentHashMap();
        idGenerator.incrementAndGet();
        this.commandHolder = new CommandHolder(this.uniqueId, retryTimeout.get());
        this.defaultTimeout = new AtomicLong(configuration.getTimeoutInSeconds());
        retryTimeout.set(configuration.getRetryTimeoutInSeconds());
        this.resultHolder = new CommandResultHolder(this.uniqueId, this.defaultTimeout.get());
        this.queueDelay = new AtomicInteger(millisecondDelayBetweenOperations.get());
    }

    public CommandQueue(String newSessionId, String newUniqueId, int opDelay, RemoteControlConfiguration configuration) {
        this(newSessionId, newUniqueId, configuration);
        this.setQueueDelay(opDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doCommand(String command, String field, String value) {
        if (this.closed.get()) {
            return "Current window or frame is closed!";
        }
        this.resultExpected.set(true);
        String result = null;
        try {
            this.doCommandWithoutWaitingForAResponse(command, field, value);
            result = this.getResult();
        }
        catch (WindowClosedException e) {
            result = "Current window or frame is closed!";
        }
        finally {
            this.resultExpected.set(false);
        }
        return result;
    }

    private String makeJavaScript() {
        return InjectionHelper.restoreJsStateInitializer(this.sessionId, this.uniqueId);
    }

    protected void doCommandWithoutWaitingForAResponse(String command, String field, String value) throws WindowClosedException {
        boolean added;
        String prevResult;
        RemoteCommand prevCommand = this.commandHolder.peek();
        if (null != prevCommand) {
            throw new IllegalStateException("unexpected command " + prevCommand + " in place before new command " + command + " could be added");
        }
        if (this.queueDelay.get() > 0) {
            log.fine("    Slow mode in effect: sleep " + this.queueDelay + " milliseconds...");
            FrameGroupCommandQueueSet.sleepForAtLeast(this.queueDelay.get());
            log.fine("    ...done");
        }
        if (null != (prevResult = this.resultHolder.peek())) {
            if (!this.proxyInjectionMode) {
                throw new IllegalStateException("A result was unexpectedly found in the result holder");
            }
            if (!"OK".equals(prevResult)) {
                if ("Current window or frame is closed!".equals(prevResult)) {
                    throw new WindowClosedException();
                }
                throw new IllegalStateException("unexpected result " + prevResult);
            }
            if (command.startsWith("wait")) {
                log.fine("Page load beat the wait command.  Leave the result to be picked up below");
            } else {
                log.fine("Apparently a page load result preceded the command; will ignore it...");
                this.resultHolder.poisonPollers();
            }
        }
        if (!(added = this.commandHolder.putCommand(new DefaultRemoteCommand(command, field, value, this.makeJavaScript())))) {
            throw new IllegalStateException("commandHolder got filled during execution of doCommandWithoutWaitingForAReponse");
        }
    }

    protected String getResult() {
        return this.resultHolder.getResult();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.closed.get()) {
            sb.append("CLOSED ");
        }
        sb.append("{ commandHolder=");
        sb.append("commandHolder/" + this.uniqueId + "-" + idGenerator.get() + " " + (this.commandHolder.isEmpty() ? "null" : this.commandHolder.peek())).append(", ").append(" resultHolder=").append("resultHolder/" + this.uniqueId + "-" + idGenerator.get() + " " + (this.resultHolder.isEmpty() ? "null" : this.resultHolder.peek())).append(" }");
        return sb.toString();
    }

    public RemoteCommand handleCommandResult(String commandResult) {
        this.handleCommandResultWithoutWaitingForACommand(commandResult);
        this.browserResponseSequencer.increaseNum();
        return this.getNextCommand();
    }

    protected void handleCommandResultWithoutWaitingForACommand(String commandResult) {
        if (commandResult != null) {
            if (!this.resultExpected.get()) {
                if (this.proxyInjectionMode) {
                    if (commandResult.startsWith("OK")) {
                        log.fine("Saw page load no one was waiting for.");
                        boolean putUnexpectedResult = this.resultHolder.putResult(commandResult);
                        if (!putUnexpectedResult) {
                            throw new IllegalStateException("The resultHolder was not empty for this unexpected result");
                        }
                    }
                } else if (commandResult.startsWith("OK")) {
                    log.warning(CommandQueue.getIdentification("resultHolder", this.uniqueId) + " unexpected response: " + commandResult);
                }
            } else {
                boolean putExpectedResult = this.resultHolder.putResult(commandResult);
                if (!putExpectedResult) {
                    throw new IllegalStateException("The resultHolder was not empty and waiting for this expected result");
                }
            }
        }
    }

    protected RemoteCommand getNextCommand() {
        return this.commandHolder.getCommand();
    }

    protected static String getIdentification(String caller, String queueId) {
        StringBuffer sb = new StringBuffer();
        if (queueId != null) {
            sb.append(queueId).append(' ');
        }
        sb.append(caller).append(' ').append(queueId);
        String s = sb.toString();
        if (s.endsWith("null")) {
            log.fine("caller identification came in ending with null");
        }
        return s;
    }

    public void endOfLife() {
        this.resultHolder.poisonPollers();
        this.commandHolder.poisonPollers();
    }

    public FrameAddress getFrameAddress() {
        return this.frameAddress;
    }

    public void setFrameAddress(FrameAddress frameAddress) {
        this.frameAddress = frameAddress;
    }

    public boolean isResultExpected() {
        return this.resultExpected.get();
    }

    public void setQueueDelay(int i) {
        this.queueDelay.set(i);
    }

    public int getQueueDelay() {
        return this.queueDelay.get();
    }

    public static void setSpeed(int i) {
        millisecondDelayBetweenOperations.set(i);
    }

    public static int getSpeed() {
        return millisecondDelayBetweenOperations.get();
    }

    public boolean isWindowPointedToByJsVariable(String jsVariableName) {
        Boolean isPointingAtThisWindow = this.cachedJsVariableNamesPointingAtThisWindow.get(jsVariableName);
        if (isPointingAtThisWindow == null) {
            isPointingAtThisWindow = false;
            this.cachedJsVariableNamesPointingAtThisWindow.put(jsVariableName, isPointingAtThisWindow);
        }
        return isPointingAtThisWindow;
    }

    public void addJsWindowNameVar(String jsWindowNameVar) {
        this.cachedJsVariableNamesPointingAtThisWindow.put(jsWindowNameVar, true);
    }

    public void declareClosed() {
        this.closed.set(true);
        if (this.resultHolder.isEmpty()) {
            this.handleCommandResultWithoutWaitingForACommand("Current window or frame is closed!");
        }
        this.endOfLife();
        this.browserResponseSequencer.increaseNum();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public BrowserResponseSequencer getBrowserResponseSequencer() {
        return this.browserResponseSequencer;
    }

    protected void setResultExpected(boolean resultExpected) {
        this.resultExpected.set(resultExpected);
    }

    protected String peekAtResult() {
        return this.resultHolder.peek();
    }

    protected RemoteCommand peekAtCommand() {
        return this.commandHolder.peek();
    }

    protected boolean putResult(String result) {
        return this.resultHolder.putResult(result);
    }

    protected boolean putCommand(RemoteCommand cmd) {
        return this.commandHolder.putCommand(cmd);
    }
}

