/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.jetty.servlet;

import org.apache.commons.logging.Log;
import org.openqa.jetty.jetty.servlet.WebApplicationContext;
import org.openqa.jetty.log.LogFactory;
import org.openqa.jetty.util.Resource;
import org.openqa.jetty.xml.XmlConfiguration;

public class JettyWebConfiguration
implements WebApplicationContext.Configuration {
    private static Log log = LogFactory.getLog(JettyWebConfiguration.class);
    private WebApplicationContext _context;

    public void setWebApplicationContext(WebApplicationContext context) {
        this._context = context;
    }

    public WebApplicationContext getWebApplicationContext() {
        return this._context;
    }

    public void configureClassPath() throws Exception {
    }

    public void configureDefaults() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureWebApp() throws Exception {
        Resource webInf;
        if (this._context.isStarted()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cannot configure webapp after it is started");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Configuring web-jetty.xml");
        }
        if ((webInf = this.getWebApplicationContext().getWebInf()) != null && webInf.isDirectory()) {
            Resource jetty = webInf.addPath("web-jetty.xml");
            if (!jetty.exists()) {
                jetty = webInf.addPath("jetty-web.xml");
            }
            if (!this.getWebApplicationContext().isIgnoreWebJetty() && jetty.exists()) {
                String[] old_server_classes = this._context.getServerClasses();
                String[] server_classes = new String[1 + (old_server_classes == null ? 0 : old_server_classes.length)];
                server_classes[0] = "-org.openqa.jetty.";
                if (server_classes != null) {
                    System.arraycopy(old_server_classes, 0, server_classes, 1, old_server_classes.length);
                }
                try {
                    this._context.setServerClasses(server_classes);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Configure: " + jetty));
                    }
                    XmlConfiguration jetty_config = new XmlConfiguration(jetty.getURL());
                    jetty_config.configure(this.getWebApplicationContext());
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (this._context.getServerClasses() == server_classes) {
                        this._context.setServerClasses(old_server_classes);
                    }
                    throw throwable;
                }
                if (this._context.getServerClasses() == server_classes) {
                    this._context.setServerClasses(old_server_classes);
                }
            }
        }
    }
}

