/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.docker.ContainerId;
import org.openqa.selenium.internal.Require;

public class ContainerInfo {
    private final String ip;
    private final ContainerId id;
    private final List<Map<String, Object>> mountedVolumes;
    private final String networkName;
    private Map<String, Object> hostConfig;
    private Map<String, String> labels;

    public ContainerInfo(ContainerId id, String ip, List<Map<String, Object>> mountedVolumes, String networkName, Map<String, Object> hostConfig) {
        this(id, ip, mountedVolumes, networkName, hostConfig, Map.of());
    }

    public ContainerInfo(ContainerId id, String ip, List<Map<String, Object>> mountedVolumes, String networkName, Map<String, Object> hostConfig, Map<String, String> labels) {
        this.ip = (String)Require.nonNull((String)"Container ip address", (Object)ip);
        this.id = (ContainerId)Require.nonNull((String)"Container id", (Object)id);
        this.mountedVolumes = (List)Require.nonNull((String)"Mounted volumes", mountedVolumes);
        this.networkName = (String)Require.nonNull((String)"Network name", (Object)networkName);
        this.hostConfig = (Map)Require.nonNull((String)"Host config", hostConfig);
        this.labels = (Map)Require.nonNull((String)"Labels", labels);
    }

    public String getIp() {
        return this.ip;
    }

    public ContainerId getId() {
        return this.id;
    }

    public List<Map<String, Object>> getMountedVolumes() {
        return this.mountedVolumes;
    }

    public String getNetworkName() {
        return this.networkName;
    }

    public Map<String, Object> getHostConfig() {
        return this.hostConfig;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public String toString() {
        return "ContainerInfo{ip=" + this.ip + ", id=" + String.valueOf(this.id) + ", networkName=" + this.networkName + ", mountedVolumes=" + Arrays.toString(this.mountedVolumes.toArray()) + "}";
    }

    public boolean equals(Object o) {
        if (!(o instanceof ContainerInfo)) {
            return false;
        }
        ContainerInfo that = (ContainerInfo)o;
        return Objects.equals(this.ip, that.ip) && Objects.equals(this.id, that.id) && Objects.equals(this.networkName, that.networkName);
    }

    public int hashCode() {
        return Objects.hash(this.ip, this.id, this.networkName);
    }
}

