/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.edge;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.Beta;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chromium.ChromiumDriver;
import org.openqa.selenium.chromium.ChromiumDriverCommandExecutor;
import org.openqa.selenium.edge.AddHasCasting;
import org.openqa.selenium.edge.AddHasCdp;
import org.openqa.selenium.edge.EdgeDriverService;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebDriverBuilder;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.service.DriverFinder;
import org.openqa.selenium.remote.service.DriverService;

public class EdgeDriver
extends ChromiumDriver {
    public EdgeDriver() {
        this(new EdgeOptions());
    }

    public EdgeDriver(EdgeOptions options) {
        this(options, ClientConfig.defaultConfig());
    }

    public EdgeDriver(EdgeOptions options, ClientConfig clientConfig) {
        this((EdgeDriverService)new EdgeDriverService.Builder().build(), options, clientConfig);
    }

    public EdgeDriver(EdgeDriverService service) {
        this(service, new EdgeOptions());
    }

    public EdgeDriver(EdgeDriverService service, EdgeOptions options) {
        this(service, options, ClientConfig.defaultConfig());
    }

    public EdgeDriver(EdgeDriverService service, EdgeOptions options, ClientConfig clientConfig) {
        super((CommandExecutor)EdgeDriver.generateExecutor(service, options, clientConfig), (Capabilities)options, "ms:edgeOptions", clientConfig);
        this.casting = new AddHasCasting().getImplementation(this.getCapabilities(), this.getExecuteMethod());
        this.cdp = new AddHasCdp().getImplementation(this.getCapabilities(), this.getExecuteMethod());
    }

    private static EdgeDriverCommandExecutor generateExecutor(EdgeDriverService service, EdgeOptions options, ClientConfig clientConfig) {
        Require.nonNull((String)"Driver service", (Object)((Object)service));
        Require.nonNull((String)"Driver options", (Object)((Object)options));
        Require.nonNull((String)"Driver clientConfig", (Object)clientConfig);
        DriverFinder finder = new DriverFinder((DriverService)service, (Capabilities)options);
        service.setExecutable(finder.getDriverPath());
        if (finder.hasBrowserPath()) {
            options.setBinary(finder.getBrowserPath());
            options.setCapability("browserVersion", null);
        }
        return new EdgeDriverCommandExecutor(service, clientConfig);
    }

    @Beta
    public static RemoteWebDriverBuilder builder() {
        return RemoteWebDriver.builder().oneOf((Capabilities)new EdgeOptions(), new Capabilities[0]);
    }

    private static class EdgeDriverCommandExecutor
    extends ChromiumDriverCommandExecutor {
        public EdgeDriverCommandExecutor(DriverService service, ClientConfig clientConfig) {
            super(service, EdgeDriverCommandExecutor.getExtraCommands(), clientConfig);
        }

        private static Map<String, CommandInfo> getExtraCommands() {
            return Stream.of(new AddHasCasting().getAdditionalCommands(), new AddHasCdp().getAdditionalCommands()).flatMap(m -> m.entrySet().stream()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }
}

