/*
Copyright 2007-2009 Selenium committers

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 */

package org.openqa.selenium.internal;

import org.openqa.selenium.Point;
import org.openqa.selenium.interactions.internal.Coordinates;

public interface Locatable {
  /**
   * Use this to discover where on the screen an element is so that we can click it. This method
   * should cause the element to be scrolled into view.
   * 
   * @return The top lefthand corner location on the screen, or null if the element is not visible
   * @deprecated To be removed in 2.31. Use {@link #getCoordinates()} instead
   */
  @Deprecated
  Point getLocationOnScreenOnceScrolledIntoView();

  Coordinates getCoordinates();
}
