/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class BuildInfo {
    private static final String BUILD_PROPERTIES_LOCATION = String.format("/%s/build.properties", BuildInfo.class.getPackage().getName().replace(".", "/"));
    private static final Properties BUILD_PROPERTIES = BuildInfo.loadBuildProperties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadBuildProperties() {
        Properties properties = new Properties();
        URL url = BuildInfo.class.getResource(BUILD_PROPERTIES_LOCATION);
        if (url == null) {
            return properties;
        }
        InputStream stream = null;
        try {
            stream = url.openStream();
            properties.load(stream);
        }
        catch (IOException ignored) {
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ignored) {}
            }
        }
        return properties;
    }

    public String getReleaseLabel() {
        return BUILD_PROPERTIES.getProperty("version", "unknown");
    }

    public String getBuildRevision() {
        return BUILD_PROPERTIES.getProperty("revision", "unknown");
    }

    public String getBuildTime() {
        return BUILD_PROPERTIES.getProperty("time", "unknown");
    }

    public String toString() {
        return String.format("Build info: version: '%s', revision: '%s', time: '%s'", this.getReleaseLabel(), this.getBuildRevision(), this.getBuildTime());
    }
}

