/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty7.server.handler;

import java.io.IOException;
import org.seleniumhq.jetty7.server.Handler;
import org.seleniumhq.jetty7.server.HandlerContainer;
import org.seleniumhq.jetty7.server.handler.AbstractHandler;
import org.seleniumhq.jetty7.util.LazyList;
import org.seleniumhq.jetty7.util.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHandlerContainer
extends AbstractHandler
implements HandlerContainer {
    @Override
    public Handler[] getChildHandlers() {
        Object list = this.expandChildren(null, null);
        return (Handler[])LazyList.toArray(list, Handler.class);
    }

    @Override
    public Handler[] getChildHandlersByClass(Class<?> byclass) {
        Object list = this.expandChildren(null, byclass);
        return (Handler[])LazyList.toArray(list, byclass);
    }

    @Override
    public <T extends Handler> T getChildHandlerByClass(Class<T> byclass) {
        Object list = this.expandChildren(null, byclass);
        if (list == null) {
            return null;
        }
        return (T)((Handler)LazyList.get(list, 0));
    }

    protected Object expandChildren(Object list, Class<?> byClass) {
        return list;
    }

    protected Object expandHandler(Handler handler, Object list, Class<Handler> byClass) {
        if (handler == null) {
            return list;
        }
        if (byClass == null || byClass.isAssignableFrom(handler.getClass())) {
            list = LazyList.add(list, handler);
        }
        if (handler instanceof AbstractHandlerContainer) {
            list = ((AbstractHandlerContainer)handler).expandChildren(list, byClass);
        } else if (handler instanceof HandlerContainer) {
            HandlerContainer container = (HandlerContainer)((Object)handler);
            Object[] handlers = byClass == null ? container.getChildHandlers() : container.getChildHandlersByClass(byClass);
            list = LazyList.addArray(list, handlers);
        }
        return list;
    }

    public static <T extends HandlerContainer> T findContainerOf(HandlerContainer root, Class<T> type, Handler handler) {
        if (root == null || handler == null) {
            return null;
        }
        Handler[] branches = root.getChildHandlersByClass(type);
        if (branches != null) {
            for (Handler h : branches) {
                HandlerContainer container = (HandlerContainer)((Object)h);
                Handler[] candidates = container.getChildHandlersByClass(handler.getClass());
                if (candidates == null) continue;
                for (Handler c : candidates) {
                    if (c != handler) continue;
                    return (T)container;
                }
            }
        }
        return null;
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.dumpThis(out);
        AbstractHandlerContainer.dump(out, indent, this.getBeans(), TypeUtil.asList(this.getHandlers()));
    }
}

