/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty7.security;

import javax.servlet.ServletContext;
import org.seleniumhq.jetty7.security.Authenticator;
import org.seleniumhq.jetty7.security.IdentityService;
import org.seleniumhq.jetty7.security.LoginService;
import org.seleniumhq.jetty7.security.authentication.BasicAuthenticator;
import org.seleniumhq.jetty7.security.authentication.ClientCertAuthenticator;
import org.seleniumhq.jetty7.security.authentication.DigestAuthenticator;
import org.seleniumhq.jetty7.security.authentication.FormAuthenticator;
import org.seleniumhq.jetty7.security.authentication.LoginAuthenticator;
import org.seleniumhq.jetty7.security.authentication.SpnegoAuthenticator;
import org.seleniumhq.jetty7.server.Server;

public class DefaultAuthenticatorFactory
implements Authenticator.Factory {
    LoginService _loginService;

    public Authenticator getAuthenticator(Server server, ServletContext context, Authenticator.AuthConfiguration configuration, IdentityService identityService, LoginService loginService) {
        String auth = configuration.getAuthMethod();
        LoginAuthenticator authenticator = null;
        if (auth == null || "BASIC".equalsIgnoreCase(auth)) {
            authenticator = new BasicAuthenticator();
        } else if ("DIGEST".equalsIgnoreCase(auth)) {
            authenticator = new DigestAuthenticator();
        } else if ("FORM".equalsIgnoreCase(auth)) {
            authenticator = new FormAuthenticator();
        } else if ("SPNEGO".equalsIgnoreCase(auth)) {
            authenticator = new SpnegoAuthenticator();
        }
        if ("CLIENT_CERT".equalsIgnoreCase(auth) || "CLIENT-CERT".equalsIgnoreCase(auth)) {
            authenticator = new ClientCertAuthenticator();
        }
        return authenticator;
    }

    public LoginService getLoginService() {
        return this._loginService;
    }

    public void setLoginService(LoginService loginService) {
        this._loginService = loginService;
    }
}

