/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.FJBGContext;
import ch.epfl.lamp.fjbg.JAttribute;
import ch.epfl.lamp.fjbg.JClass;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class JSourceFileAttribute
extends JAttribute {
    protected final String sourceFileName;
    protected final int sourceFileIndex;

    public JSourceFileAttribute(FJBGContext context2, JClass clazz2, String sourceFileName) {
        super(context2, clazz2);
        this.sourceFileName = sourceFileName;
        this.sourceFileIndex = clazz2.getConstantPool().addUtf8(sourceFileName);
    }

    public JSourceFileAttribute(FJBGContext context2, JClass clazz2, Object owner, String name, int size2, DataInputStream stream) throws IOException {
        super(context2, clazz2, name);
        this.sourceFileIndex = stream.readShort();
        this.sourceFileName = clazz2.getConstantPool().lookupUtf8(this.sourceFileIndex);
        assert (name.equals(this.getName()));
    }

    public String getName() {
        return "SourceFile";
    }

    public String getFileName() {
        return this.sourceFileName;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("  SourceFile: \"");
        buf.append(this.sourceFileName);
        buf.append("\"\n");
        return buf.toString();
    }

    protected int getSize() {
        return 2;
    }

    protected void writeContentsTo(DataOutputStream stream) throws IOException {
        stream.writeShort(this.sourceFileIndex);
    }
}

