/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.ajax4jsf.model.DataVisitResult;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.renderkit.RendererUtils;
import org.richfaces.component.AbstractList;
import org.richfaces.component.ListType;
import org.richfaces.component.UISequence;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.renderkit.ComponentAttribute;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.SequenceRendererHelper;

@ResourceDependency(library="org.richfaces", name="list.ecss")
public abstract class ListRendererBase
extends Renderer {
    private static final Map<String, ComponentAttribute> ROW_HANDLER_ATTRIBUTES = Collections.unmodifiableMap(ComponentAttribute.createMap((ComponentAttribute[])new ComponentAttribute[]{new ComponentAttribute("onclick").setEventNames(new String[]{"rowclick"}).setComponentAttributeName("onrowclick"), new ComponentAttribute("ondblclick").setEventNames(new String[]{"rowdblclick"}).setComponentAttributeName("onrowdblclick"), new ComponentAttribute("onmousedown").setEventNames(new String[]{"rowmousedown"}).setComponentAttributeName("onrowmousedown"), new ComponentAttribute("onmouseup").setEventNames(new String[]{"rowmouseup"}).setComponentAttributeName("onrowmouseup"), new ComponentAttribute("onmouseover").setEventNames(new String[]{"rowmouseover"}).setComponentAttributeName("onrowmouseover"), new ComponentAttribute("onmousemove").setEventNames(new String[]{"rowmousemove"}).setComponentAttributeName("onrowmousemove"), new ComponentAttribute("onmouseout").setEventNames(new String[]{"rowmouseout"}).setComponentAttributeName("onrowmouseout"), new ComponentAttribute("onkeypress").setEventNames(new String[]{"rowkeypress"}).setComponentAttributeName("onrowkeypress"), new ComponentAttribute("onkeydown").setEventNames(new String[]{"rowkeydown"}).setComponentAttributeName("onrowkeydown"), new ComponentAttribute("onkeyup").setEventNames(new String[]{"rowkeyup"}).setComponentAttributeName("onrowkeyup")}));
    private RendererUtils rendererUtils = RendererUtils.getInstance();
    private ItemsEncoder unorderedListItemsEncoder = new SimpleItemsEncoder("rf-lst-i rf-ulst-i");
    private ItemsEncoder orderedListItemsEncoder = new SimpleItemsEncoder("rf-lst-i rf-olst-i");
    private ItemsEncoder definitionItemsEncoder = new DefinitionItemsEncoder();

    protected String getListClass(ListType type) {
        switch (type) {
            case ordered: {
                return "rf-lst rf-olst";
            }
            case unordered: {
                return "rf-lst rf-ulst";
            }
            case definitions: {
                return "rf-lst rf-dlst";
            }
        }
        throw new IllegalArgumentException(type.toString());
    }

    protected ItemsEncoder getItemsEncoderByType(ListType type) {
        switch (type) {
            case ordered: {
                return this.orderedListItemsEncoder;
            }
            case unordered: {
                return this.unorderedListItemsEncoder;
            }
            case definitions: {
                return this.definitionItemsEncoder;
            }
        }
        throw new IllegalArgumentException(type.toString());
    }

    protected ListType getType(UIComponent component) {
        ListType type = ((AbstractList)component).getType();
        if (type == null) {
            String exceptionMessage = MessageFormat.format("Type for rich:list {0} is required!", RichfacesLogger.getComponentPath((UIComponent)component));
            throw new IllegalArgumentException(exceptionMessage);
        }
        return type;
    }

    protected String getStyleClass(UIComponent component, ListType listType) {
        String styleClass = (String)component.getAttributes().get("styleClass");
        return HtmlUtil.concatClasses((String[])new String[]{styleClass, this.getListClass(listType)});
    }

    protected String getElementId(FacesContext facesContext, UIComponent component) {
        if (this.rendererUtils.hasExplicitId(component)) {
            return component.getClientId(facesContext);
        }
        return null;
    }

    protected void encodeListItems(FacesContext context, UIComponent component, ListType listType) throws IOException {
        AbstractList list = (AbstractList)component;
        try {
            ItemsEncoder itemsEncoder = this.getItemsEncoderByType(listType);
            SequenceRendererHelper rendererHelper = new SequenceRendererHelper((UISequence)list);
            list.walk(context, itemsEncoder, rendererHelper);
            if (!rendererHelper.hasWalkedOverRows()) {
                itemsEncoder.encodeFakeItem(context, component);
            }
        }
        catch (FacesException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    private abstract class ItemsEncoder
    implements DataVisitor {
        private ItemsEncoder() {
        }

        protected void renderHandlers(FacesContext context, UISequence sequence) throws IOException {
            RenderKitUtils.renderPassThroughAttributesOptimized((FacesContext)context, (UIComponent)sequence, (Map)ROW_HANDLER_ATTRIBUTES);
        }

        protected abstract void encodeRow(FacesContext var1, UISequence var2, SequenceRendererHelper var3) throws IOException;

        public DataVisitResult process(FacesContext context, Object rowKey, Object argument) {
            SequenceRendererHelper helper = (SequenceRendererHelper)argument;
            UISequence sequence = helper.getSequence();
            sequence.setRowKey(context, rowKey);
            if (sequence.isRowAvailable()) {
                helper.nextRow();
                try {
                    this.encodeRow(context, sequence, helper);
                }
                catch (IOException e) {
                    throw new FacesException(e.getMessage(), (Throwable)e);
                }
                return DataVisitResult.CONTINUE;
            }
            return DataVisitResult.STOP;
        }

        public abstract void encodeFakeItem(FacesContext var1, UIComponent var2) throws IOException;
    }

    private final class DefinitionItemsEncoder
    extends ItemsEncoder {
        private DefinitionItemsEncoder() {
        }

        protected void encodeRow(FacesContext context, UISequence sequence, SequenceRendererHelper helper) throws IOException {
            ResponseWriter writer = context.getResponseWriter();
            UIComponent termFacet = sequence.getFacet("term");
            if (termFacet != null) {
                writer.startElement("dt", (UIComponent)sequence);
                if (ListRendererBase.this.rendererUtils.hasExplicitId((UIComponent)sequence)) {
                    ListRendererBase.this.rendererUtils.writeAttribute(writer, "id", (Object)(sequence.getClientId(context) + ".dt"));
                }
                ListRendererBase.this.rendererUtils.writeAttribute(writer, "class", (Object)HtmlUtil.concatClasses((String[])new String[]{helper.getRowClass(), helper.getColumnClass(), "rf-lst-t rf-dlst-t"}));
                termFacet.encodeAll(context);
                writer.endElement("dt");
            }
            writer.startElement("dd", (UIComponent)sequence);
            if (ListRendererBase.this.rendererUtils.hasExplicitId((UIComponent)sequence)) {
                ListRendererBase.this.rendererUtils.writeAttribute(writer, "id", (Object)sequence.getClientId(context));
            }
            ListRendererBase.this.rendererUtils.writeAttribute(writer, "class", (Object)HtmlUtil.concatClasses((String[])new String[]{helper.getRowClass(), helper.getColumnClass(), "rf-lst-i rf-dlst-d"}));
            this.renderHandlers(context, sequence);
            ListRendererBase.this.rendererUtils.encodeChildren(context, (UIComponent)sequence);
            writer.endElement("dd");
        }

        public void encodeFakeItem(FacesContext context, UIComponent component) throws IOException {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("dd", component);
            writer.writeAttribute("style", (Object)"display:none", null);
            writer.endElement("dd");
        }
    }

    private class SimpleItemsEncoder
    extends ItemsEncoder {
        private String itemClass;

        public SimpleItemsEncoder(String itemClass) {
            this.itemClass = itemClass;
        }

        protected void encodeRow(FacesContext context, UISequence sequence, SequenceRendererHelper helper) throws IOException {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("li", (UIComponent)sequence);
            if (ListRendererBase.this.rendererUtils.hasExplicitId((UIComponent)sequence)) {
                ListRendererBase.this.rendererUtils.writeAttribute(writer, "id", (Object)sequence.getClientId(context));
            }
            ListRendererBase.this.rendererUtils.writeAttribute(writer, "class", (Object)HtmlUtil.concatClasses((String[])new String[]{helper.getRowClass(), helper.getColumnClass(), this.itemClass}));
            this.renderHandlers(context, sequence);
            ListRendererBase.this.rendererUtils.encodeChildren(context, (UIComponent)sequence);
            writer.endElement("li");
        }

        public void encodeFakeItem(FacesContext context, UIComponent component) throws IOException {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("li", component);
            writer.writeAttribute("style", (Object)"display:none", null);
            writer.endElement("li");
        }
    }
}

