/**
 * 
 */
package org.ajax4jsf.config;

class ServletMapping {
	private final String servletName;
	private final String urlPattern;

	/**
	 * @param servletName
	 * @param urlPattern
	 */
	public ServletMapping(String servletName, String urlPattern) {
		super();
		this.servletName = servletName;
		this.urlPattern = urlPattern;
	}

	public String getServletName() {
		return servletName;
	}

	public String getUrlPattern() {
		return urlPattern;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((servletName == null) ? 0 : servletName.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ServletMapping other = (ServletMapping) obj;
		if (servletName == null) {
			if (other.servletName != null)
				return false;
		} else if (!servletName.equals(other.servletName))
			return false;
		return true;
	}
}